/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.compiler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.AttributeUtil;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class AttributeIndexer
extends Task {
    private File jarFile;
    private HashMap attributes = new HashMap();
    private Path classPath;
    private File baseName;
    private boolean inMaven = false;
    private static final String INDEX_FILENAME = "META-INF/attrs.index";
    private static final String SUFFIX = "$__attributeRepository";
    private static final String CLASS_SUFFIX = "$__attributeRepository.class";
    private static final String SOURCE_SUFFIX = "$__attributeRepository.java";
    static /* synthetic */ Class class$org$apache$commons$attributes$Indexed;

    protected void addAttribute(String className, String attributeName) {
        HashSet<String> thisAttr = (HashSet<String>)this.attributes.get(attributeName);
        if (thisAttr == null) {
            thisAttr = new HashSet<String>();
            this.attributes.put(attributeName, thisAttr);
        }
        thisAttr.add(className);
    }

    public void setJarfile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setBaseName(File baseName) {
        this.inMaven = true;
        this.baseName = baseName;
    }

    public Path createClasspath() {
        this.classPath = new Path(((ProjectComponent)this).project);
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyEntry(JarFile jar, JarEntry entry, JarOutputStream outputStream) throws Exception {
        outputStream.putNextEntry(entry);
        if (!entry.isDirectory()) {
            BufferedInputStream is = new BufferedInputStream(jar.getInputStream(entry));
            try {
                int numRead;
                byte[] buffer = new byte[16384];
                while ((numRead = ((InputStream)is).read(buffer, 0, 16384)) != 0 && numRead != -1) {
                    outputStream.write(buffer, 0, numRead);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            {
            }
        }
    }

    protected void findJarFile() throws BuildException {
        File[] allFiles = this.baseName.getParentFile().listFiles();
        if (allFiles == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
        long newestDate = 0L;
        int i = 0;
        while (i < allFiles.length) {
            String name = allFiles[i].getName();
            if (name.startsWith(this.baseName.getName()) && name.endsWith(".jar") && allFiles[i].lastModified() > newestDate) {
                this.jarFile = allFiles[i];
                newestDate = allFiles[i].lastModified();
            }
            ++i;
        }
        if (this.jarFile == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.inMaven) {
            this.findJarFile();
        }
        if (!this.jarFile.exists()) {
            this.log("Can't find " + this.jarFile.getPath());
            return;
        }
        try {
            this.log("Building attribute index for " + this.jarFile.getPath());
            AntClassLoader cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), ((ProjectComponent)this).project, this.classPath, true);
            cl.addPathElement(this.jarFile.getPath());
            JarFile jar = new JarFile(this.jarFile);
            File newJarFile = new File(this.jarFile.getPath() + ".new");
            JarOutputStream output = new JarOutputStream(new FileOutputStream(newJarFile));
            try {
                Enumeration<JarEntry> enumeration = jar.entries();
                while (enumeration.hasMoreElements()) {
                    String className;
                    JarEntry entry = enumeration.nextElement();
                    if (!entry.isDirectory() && (className = entry.getName()).endsWith(CLASS_SUFFIX)) {
                        className = className.replace('/', '.').replace('\\', '.');
                        String baseClassName = className.substring(0, className.length() - CLASS_SUFFIX.length()).replace('$', '.');
                        className = className.substring(0, className.length() - 6);
                        Class<?> repoClass = cl.loadClass(className);
                        AttributeRepositoryClass repo = (AttributeRepositoryClass)repoClass.newInstance();
                        Set classAttrs = repo.getClassAttributes();
                        Collection indexedAttrs = new HashSet();
                        Iterator inner = classAttrs.iterator();
                        while (inner.hasNext()) {
                            indexedAttrs.add(inner.next().getClass());
                        }
                        indexedAttrs = AttributeUtil.getClassesWithAttributeType(indexedAttrs, (Class)(class$org$apache$commons$attributes$Indexed == null ? AttributeIndexer.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed));
                        inner = indexedAttrs.iterator();
                        while (inner.hasNext()) {
                            this.addAttribute(baseClassName, ((Class)inner.next()).getName());
                        }
                    }
                    if (entry.getName().equals(INDEX_FILENAME)) continue;
                    this.copyEntry(jar, entry, output);
                }
                output.putNextEntry(new JarEntry(INDEX_FILENAME));
                Iterator attrs = this.attributes.keySet().iterator();
                while (attrs.hasNext()) {
                    String attrName = (String)attrs.next();
                    output.write(("Attribute: " + attrName + "\n").getBytes());
                    Iterator classes = ((Collection)this.attributes.get(attrName)).iterator();
                    while (classes.hasNext()) {
                        output.write(("Class: " + classes.next() + "\n").getBytes());
                    }
                    output.write("\n".getBytes());
                }
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                output.close();
                jar.close();
                throw throwable;
            }
            output.close();
            jar.close();
            cl.cleanup();
            this.jarFile.delete();
            newJarFile.renameTo(this.jarFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INDEX_FILENAME = INDEX_FILENAME;
        SUFFIX = SUFFIX;
        CLASS_SUFFIX = CLASS_SUFFIX;
        SOURCE_SUFFIX = SOURCE_SUFFIX;
    }
}

