/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.context.ApplicationEvent;

public class RequestHandledEvent
extends ApplicationEvent {
    private String url;
    private long timeMillis;
    private String ipAddress;
    private String method;
    private String servletName;
    private Throwable failureCause;

    public RequestHandledEvent(Object source, String url, long timeMillis, String ip, String method, String servletName) {
        super(source);
        this.url = url;
        this.timeMillis = timeMillis;
        this.ipAddress = ip;
        this.method = method;
        this.servletName = servletName;
    }

    public RequestHandledEvent(Object source, String url, long timeMillis, String ip, String method, String servletName, Throwable ex) {
        this(source, url, timeMillis, ip, method, servletName);
        this.failureCause = ex;
    }

    public String getURL() {
        return this.url;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMethod() {
        return this.method;
    }

    public String getServletName() {
        return this.servletName;
    }

    public boolean wasFailure() {
        return this.failureCause != null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestHandledEvent: url=[" + this.getURL() + "] time=" + this.getTimeMillis() + "ms");
        sb.append(" client=" + this.getIpAddress() + " method='" + this.getMethod() + "' servlet='" + this.getServletName() + "'");
        sb.append(" status=" + sb.append(!this.wasFailure() ? "OK" : "failed: " + this.getFailureCause()));
        return sb.toString();
    }
}

