/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.external;

import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ExternalTransaction
implements Transaction {
    private DataSource dataSource;
    private Connection connection;

    public ExternalTransaction(DataSource ds) throws SQLException, TransactionException {
        this.dataSource = ds;
        if (this.dataSource == null) {
            throw new TransactionException("ExternalTransaction initialization failed.  DataSource was null.");
        }
        this.connection = this.dataSource.getConnection();
        if (this.connection == null) {
            throw new TransactionException("ExternalTransaction could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
    }

    public void commit() throws SQLException, TransactionException {
    }

    public void rollback() throws SQLException, TransactionException {
    }

    public void close() throws SQLException, TransactionException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Connection getConnection() throws SQLException, TransactionException {
        return this.connection;
    }
}

