/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.BaseStatement;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class GeneralStatement
extends BaseStatement {
    private static final RowHandler DEFAULT_ROW_HANDLER = new DefaultRowHandler();
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
    static /* synthetic */ Class class$java$lang$String;

    public int executeUpdate(RequestScope request, Connection conn, Object parameterObject) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        request.getSession().setCommitRequired(true);
        try {
            this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(request, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(request, parameterObject);
            request.setResultMap(resultMap);
            request.setParameterMap(parameterMap);
            int rows = 0;
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(request, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(request, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the statement or the result map.");
            rows = this.sqlExecuteUpdate(request, conn, sqlString, parameters);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(request, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(request);
            this.notifyListeners();
            return rows;
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), (Throwable)e);
        }
    }

    public Object executeQueryForObject(RequestScope request, Connection conn, Object parameterObject, Object resultObject) throws SQLException {
        Object object = null;
        List list = this.executeQueryWithCallback(request, conn, parameterObject, resultObject, DEFAULT_ROW_HANDLER, 0, -999999);
        if (list.size() > 1) {
            throw new SQLException("Error: executeQueryForObject returned too many results.");
        }
        if (list.size() > 0) {
            object = list.get(0);
        }
        return object;
    }

    public List executeQueryForList(RequestScope request, Connection conn, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        return this.executeQueryWithCallback(request, conn, parameterObject, null, DEFAULT_ROW_HANDLER, skipResults, maxResults);
    }

    public List executeQueryForList(RequestScope request, Connection conn, Object parameterObject, RowHandler rowHandler) throws SQLException {
        return this.executeQueryWithCallback(request, conn, parameterObject, null, rowHandler, 0, -999999);
    }

    protected List executeQueryWithCallback(RequestScope request, Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler, int skipResults, int maxResults) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        try {
            this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(request, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(request, parameterObject);
            request.setResultMap(resultMap);
            request.setParameterMap(parameterMap);
            ArrayList resultList = new ArrayList();
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(request, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(request, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the SQL statement or the result map.");
            RowHandlerCallback callback = new RowHandlerCallback(resultMap, resultList, resultObject, rowHandler);
            this.sqlExecuteQuery(request, conn, sqlString, parameters, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(request, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(request);
            this.notifyListeners();
            return resultList;
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), (Throwable)e);
        }
    }

    protected void postProcessParameterObject(RequestScope request, Object parameterObject, Object[] parameters) {
    }

    protected int sqlExecuteUpdate(RequestScope request, Connection conn, String sqlString, Object[] parameters) throws SQLException {
        if (request.getSession().isInBatch()) {
            this.getSqlExecutor().addBatch(request, conn, sqlString, parameters);
            return 0;
        }
        return this.getSqlExecutor().executeUpdate(request, conn, sqlString, parameters);
    }

    protected void sqlExecuteQuery(RequestScope request, Connection conn, String sqlString, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        this.getSqlExecutor().executeQuery(request, conn, sqlString, parameters, skipResults, maxResults, callback);
    }

    protected void validateParameter(Object param) throws SQLException {
        Class parameterClass = this.getParameterClass();
        if (param != null && parameterClass != null && ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = GeneralStatement.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(parameterClass) ? param.getClass() != (class$java$lang$String == null ? (class$java$lang$String = GeneralStatement.class$("java.lang.String")) : class$java$lang$String) : !parameterClass.isAssignableFrom(param.getClass()))) {
            throw new SQLException("Invalid parameter object type.  Expected '" + parameterClass.getName() + "' but found '" + param.getClass().getName() + "'.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

