/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.common.beans.BeanProbe;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.BaseTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IterateTagHandler
extends BaseTagHandler {
    public int doStartFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject) {
        IterateContext iterate = (IterateContext)ctx.getAttribute(tag);
        if (iterate == null) {
            String prop = tag.getPropertyAttr();
            Object collection = prop != null ? BeanProbe.getObject((Object)parameterObject, (String)tag.getPropertyAttr()) : parameterObject;
            iterate = new IterateContext(collection);
            ctx.setAttribute(tag, iterate);
        }
        if (iterate != null && iterate.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int doEndFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject, StringBuffer bodyContent) {
        IterateContext iterate = (IterateContext)ctx.getAttribute(tag);
        if (iterate.hasNext()) {
            String close;
            String conj;
            String open;
            iterate.next();
            String propName = tag.getPropertyAttr();
            if (propName == null) {
                propName = "";
            }
            String find = propName + "[]";
            String replace = propName + "[" + iterate.getIndex() + "]";
            IterateTagHandler.replace(bodyContent, find, replace);
            if (iterate.isFirst() && (open = tag.getOpenAttr()) != null) {
                bodyContent.insert(0, open);
            }
            if (!iterate.isLast() && (conj = tag.getConjunctionAttr()) != null) {
                bodyContent.append(conj);
            }
            if (iterate.isLast() && (close = tag.getCloseAttr()) != null) {
                bodyContent.append(close);
            }
            return 2;
        }
        return 1;
    }

    public void doPrepend(SqlTagContext ctx, SqlTag tag, Object parameterObject, StringBuffer bodyContent) {
        IterateContext iterate = (IterateContext)ctx.getAttribute(tag);
        if (iterate.isFirst()) {
            super.doPrepend(ctx, tag, parameterObject, bodyContent);
        }
    }

    private static void replace(StringBuffer buffer, String find, String replace) {
        int pos = buffer.toString().indexOf(find);
        int len = find.length();
        while (pos > -1) {
            buffer.replace(pos, pos + len, replace);
            pos = buffer.toString().indexOf(find);
        }
    }

    public boolean isPostParseRequired() {
        return true;
    }

    private class IterateContext
    implements Iterator {
        private Iterator iterator;
        private int index = -1;

        public IterateContext(Object collection) {
            if (collection instanceof Collection) {
                this.iterator = ((Collection)collection).iterator();
            } else if (collection instanceof Iterator) {
                this.iterator = (Iterator)collection;
            } else if (collection.getClass().isArray()) {
                List list = BeanProbe.arrayToList((Object)collection);
                this.iterator = list.iterator();
            } else {
                throw new SqlMapException("ParameterObject or property was not a Collection, Array or Iterator.");
            }
        }

        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        public Object next() {
            ++this.index;
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.iterator != null && !this.iterator.hasNext();
        }
    }
}

