/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapSessionImpl
implements SqlMapSession {
    public SqlMapExecutorDelegate delegate;
    public SessionScope session;
    public boolean closed;

    public SqlMapSessionImpl(ExtendedSqlMapClient client) {
        this.delegate = client.getDelegate();
        this.session = this.delegate.popSession();
        this.session.setSqlMapClient(client);
        this.session.setSqlMapExecutor(client);
        this.session.setSqlMapTxMgr(client);
        this.closed = false;
    }

    public void open() {
        this.session.setSqlMapTxMgr(this);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.delegate.pushSession(this.session);
        this.session = null;
        this.delegate = null;
        this.closed = true;
    }

    public Object insert(String id, Object param) throws SQLException {
        return this.delegate.insert(this.session, id, param);
    }

    public int update(String id, Object param) throws SQLException {
        return this.delegate.update(this.session, id, param);
    }

    public int delete(String id, Object param) throws SQLException {
        return this.delegate.delete(this.session, id, param);
    }

    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForObject(this.session, id, paramObject);
    }

    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.delegate.queryForObject(this.session, id, paramObject, resultObject);
    }

    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForList(this.session, id, paramObject);
    }

    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.delegate.queryForList(this.session, id, paramObject, skip, max);
    }

    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.delegate.queryForPaginatedList(this.session, id, paramObject, pageSize);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.delegate.queryForMap(this.session, id, paramObject, keyProp);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.delegate.queryForMap(this.session, id, paramObject, keyProp, valueProp);
    }

    public List queryForList(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        return this.delegate.queryForList(this.session, id, paramObject, rowHandler);
    }

    public void startTransaction() throws SQLException {
        this.delegate.startTransaction(this.session);
    }

    public void commitTransaction() throws SQLException {
        this.delegate.commitTransaction(this.session);
    }

    public void endTransaction() throws SQLException {
        this.delegate.endTransaction(this.session);
    }

    public void startBatch() throws SQLException {
        this.delegate.startBatch(this.session);
    }

    public int executeBatch() throws SQLException {
        return this.delegate.executeBatch(this.session);
    }

    public void setUserConnection(Connection connection) throws SQLException {
        this.delegate.setUserConnection(this.session, connection);
    }

    public Connection getUserConnection() throws SQLException {
        return this.delegate.getUserConnection(this.session);
    }

    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }
}

