/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapClientImpl
implements ExtendedSqlMapClient {
    public SqlMapExecutorDelegate delegate;
    private ThreadLocal localSqlMapSession = new ThreadLocal();

    public SqlMapClientImpl(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public Object insert(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().insert(id, param);
    }

    public int update(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().update(id, param);
    }

    public int delete(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().delete(id, param);
    }

    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject);
    }

    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject, resultObject);
    }

    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject);
    }

    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject, skip, max);
    }

    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.getLocalSqlMapSession().queryForPaginatedList(id, paramObject, pageSize);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp, valueProp);
    }

    public List queryForList(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject, rowHandler);
    }

    public void startTransaction() throws SQLException {
        this.getLocalSqlMapSession().startTransaction();
    }

    public void commitTransaction() throws SQLException {
        this.getLocalSqlMapSession().commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() throws SQLException {
        try {
            this.getLocalSqlMapSession().endTransaction();
            Object var2_1 = null;
            this.getLocalSqlMapSession().close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getLocalSqlMapSession().close();
            throw throwable;
        }
    }

    public void startBatch() throws SQLException {
        this.getLocalSqlMapSession().startBatch();
    }

    public int executeBatch() throws SQLException {
        return this.getLocalSqlMapSession().executeBatch();
    }

    public void setUserConnection(Connection connection) throws SQLException {
        this.getLocalSqlMapSession().setUserConnection(connection);
    }

    public Connection getUserConnection() throws SQLException {
        return this.getLocalSqlMapSession().getUserConnection();
    }

    public DataSource getDataSource() {
        return this.getLocalSqlMapSession().getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public SqlMapSession openSession() {
        SqlMapSessionImpl sqlMapSession = this.getLocalSqlMapSession();
        sqlMapSession.open();
        return sqlMapSession;
    }

    public SqlMapSession getSession() {
        return this.openSession();
    }

    private SqlMapSessionImpl getLocalSqlMapSession() {
        SqlMapSessionImpl sqlMapSession = (SqlMapSessionImpl)this.localSqlMapSession.get();
        if (sqlMapSession == null || sqlMapSession.isClosed()) {
            sqlMapSession = new SqlMapSessionImpl(this);
            this.localSqlMapSession.set(sqlMapSession);
        }
        return sqlMapSession;
    }
}

