/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

public class CacheKey {
    private int multiplier;
    private int hashcode;
    private long checksum;
    private static final int DEFAULT_MULTIPLYER = 37;
    private static final int DEFAULT_HASHCODE = 17;

    public CacheKey() {
        this.hashcode = 17;
        this.multiplier = 37;
    }

    public CacheKey(int initialNonZeroOddNumber) {
        this.hashcode = initialNonZeroOddNumber;
        this.multiplier = 37;
    }

    public CacheKey(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber) {
        this.hashcode = initialNonZeroOddNumber;
        this.multiplier = multiplierNonZeroOddNumber;
    }

    public CacheKey update(int x) {
        this.hashcode = this.multiplier * this.hashcode + (x ^ x >>> 32);
        this.checksum += (long)x;
        return this;
    }

    public CacheKey update(Object object) {
        this.update(object.hashCode());
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)object;
        if (this.hashcode != cacheKey.hashcode) {
            return false;
        }
        return this.checksum == cacheKey.checksum;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

