/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.PrimaryKey;
import net.sf.hibernate.mapping.SimpleValue;

public abstract class IdentifierCollection
extends Collection {
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private SimpleValue identifier;

    public IdentifierCollection(PersistentClass owner) {
        super(owner);
    }

    public SimpleValue getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(SimpleValue identifier) {
        this.identifier = identifier;
    }

    public final boolean isIdentified() {
        return true;
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getIdentifier().getColumnIterator());
            this.getCollectionTable().setPrimaryKey(pk);
        }
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("collection id mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIdentifier().getType().getName());
        }
    }
}

