/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.Type;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final QueryableCollection collectionPersister;
    private final Type keyType;

    public CollectionLoader(QueryableCollection persister, SessionFactoryImplementor session) throws MappingException {
        this(persister, 1, session);
    }

    public CollectionLoader(QueryableCollection persister, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        super(factory.getDialect());
        this.keyType = persister.getKeyType();
        String alias = this.generateRootAlias(persister.getRole());
        List associations = this.walkCollectionTree(persister, alias, factory);
        int joins = associations.size();
        this.suffixes = CollectionLoader.generateSuffixes(joins);
        this.sql = this.renderStatementString(persister, alias, associations, batchSize, factory);
        this.classPersisters = new Loadable[joins];
        this.lockModeArray = this.createLockModeArray(joins, LockMode.NONE);
        for (int i = 0; i < joins; ++i) {
            this.classPersisters[i] = (Loadable)((Object)((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i)).joinable);
        }
        this.collectionPersister = persister;
        this.postInstantiate();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, id, this.keyType);
    }

    public final String renderStatementString(QueryableCollection persister, String alias, List associations, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        StringBuffer whereString = CollectionLoader.whereString(alias, persister.getKeyColumnNames(), batchSize);
        if (persister.hasWhere()) {
            whereString.append(" and ").append(persister.getSQLWhereString(alias));
        }
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select().setSelectClause(persister.selectClauseFragment(alias) + this.selectString(associations, factory)).setFromClause(persister.getTableName(), alias).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        if (persister.hasOrdering()) {
            select.setOrderByClause(persister.getSQLOrderByString(alias));
        }
        return select.toStatementString();
    }

    protected int getJoinType(AssociationType type, int config, String path, String table, String[] foreignKeyColumns, SessionFactoryImplementor factory) throws MappingException {
        int joinType = super.getJoinType(type, config, path, table, foreignKeyColumns, factory);
        if (joinType == 1 && "".equals(path)) {
            joinType = 0;
        }
        return joinType;
    }
}

