/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jmx;

import java.util.Properties;
import javax.naming.InitialContext;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.jmx.HibernateServiceMBean;
import net.sf.hibernate.jmx.SessionFactoryStub;
import net.sf.hibernate.util.NamingHelper;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HibernateService
implements HibernateServiceMBean {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$jmx$HibernateServiceMBean == null ? (class$net$sf$hibernate$jmx$HibernateServiceMBean = HibernateService.class$("net.sf.hibernate.jmx.HibernateServiceMBean")) : class$net$sf$hibernate$jmx$HibernateServiceMBean));
    private String mapResources;
    private String boundName;
    private Properties properties = new Properties();
    static /* synthetic */ Class class$net$sf$hibernate$jmx$HibernateServiceMBean;

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public String getMapResources() {
        return this.mapResources;
    }

    public void setMapResources(String mapResources) {
        this.mapResources = mapResources == null ? null : mapResources.trim();
    }

    public void addMapResource(String mapResource) {
        this.mapResources = this.mapResources == null || this.mapResources.length() == 0 ? mapResource.trim() : this.mapResources + ", " + mapResource.trim();
    }

    protected boolean getBooleanProperty(String propName) {
        return PropertiesHelper.getBoolean(propName, this.properties);
    }

    protected void setProperty(String propName, boolean value) {
        this.setProperty(propName, value ? "true" : "false");
    }

    protected void setProperty(String propName, Integer value) {
        this.setProperty(propName, value == null ? null : value.toString());
    }

    protected Integer getIntegerProperty(String propName) {
        return PropertiesHelper.getInteger(propName, this.properties);
    }

    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    public void setDatasource(String datasource) {
        this.setProperty("hibernate.connection.datasource", datasource);
    }

    public String getDialect() {
        return this.getProperty("hibernate.dialect");
    }

    public void setDialect(String dialect) {
        this.setProperty("hibernate.dialect", dialect);
    }

    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public void setJndiName(String jndiName) {
        this.setProperty("hibernate.session_factory_name", jndiName);
    }

    public boolean getUseOuterJoin() {
        return this.getBooleanProperty("hibernate.use_outer_join");
    }

    public void setUseOuterJoin(boolean uoj) {
        this.setProperty("hibernate.use_outer_join", uoj);
    }

    public boolean getShowSql() {
        return this.getBooleanProperty("hibernate.show_sql");
    }

    public void setShowSql(boolean showSql) {
        this.setProperty("hibernate.show_sql", showSql);
    }

    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    public void setUserName(String userName) {
        this.setProperty("hibernate.connection.username", userName);
    }

    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    public void setPassword(String password) {
        this.setProperty("hibernate.connection.password", password);
    }

    private static String[] parseResourceList(String resourceList) {
        return PropertiesHelper.toStringArray(resourceList, " ,\n\t\r\f");
    }

    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException he) {
            log.info((Object)("Could not build SessionFactory using the MBean classpath - will try again using client classpath: " + he.getMessage()));
            log.debug((Object)"Error was", (Throwable)he);
            new SessionFactoryStub(this);
        }
    }

    public void stop() {
        log.info((Object)"stopping service");
        try {
            InitialContext context = NamingHelper.getInitialContext(this.getProperties());
            ((SessionFactory)context.lookup(this.boundName)).close();
        }
        catch (Exception e) {
            log.warn((Object)"exception while stopping service", (Throwable)e);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        log.info((Object)("starting service at JNDI name: " + this.boundName));
        log.info((Object)("service properties: " + this.properties));
        Configuration cfg = new Configuration().addProperties(this.getProperties());
        String[] mappingFiles = HibernateService.parseResourceList(this.getMapResources());
        for (int i = 0; i < mappingFiles.length; ++i) {
            cfg.addResource(mappingFiles[i], Thread.currentThread().getContextClassLoader());
        }
        return cfg.buildSessionFactory();
    }

    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    public void setTransactionStrategy(String txnStrategy) {
        this.setProperty("hibernate.transaction.factory_class", txnStrategy);
    }

    public void setUserTransactionName(String utName) {
        this.setProperty("jta.UserTransaction", utName);
    }

    public String getTransactionManagerLookupStrategy() {
        return this.getProperty("hibernate.transaction.manager_lookup_class");
    }

    public void setTransactionManagerLookupStrategy(String lkpStrategy) {
        this.setProperty("hibernate.transaction.manager_lookup_class", lkpStrategy);
    }

    public String getPropertyList() {
        return this.getProperties().toString();
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public String getCacheProvider() {
        return this.getProperty("hibernate.cache.provider_class");
    }

    public String getDefaultSchema() {
        return this.getProperty("hibernate.default_schema");
    }

    public Integer getJdbcBatchSize() {
        return this.getIntegerProperty("hibernate.jdbc.batch_size");
    }

    public Integer getJdbcFetchSize() {
        return this.getIntegerProperty("hibernate.jdbc.fetch_size");
    }

    public Integer getMaxFetchDepth() {
        return this.getIntegerProperty("hibernate.max_fetch_depth");
    }

    public boolean getUseQueryCache() {
        return this.getBooleanProperty("hibernate.cache.use_query_cache");
    }

    public String getQuerySubstitutions() {
        return this.getProperty("hibernate.query.substitutions");
    }

    public void setCacheProvider(String cacheProvider) {
        this.setProperty("hibernate.cache.provider_class", cacheProvider);
    }

    public void setDefaultSchema(String schema) {
        this.setProperty("hibernate.default_schema", schema);
    }

    public void setJdbcBatchSize(Integer depth) {
        this.setProperty("hibernate.jdbc.batch_size", depth);
    }

    public void setJdbcFetchSize(Integer depth) {
        this.setProperty("hibernate.jdbc.fetch_size", depth);
    }

    public void setMaxFetchDepth(Integer depth) {
        this.setProperty("hibernate.max_fetch_depth", depth);
    }

    public void setUseQueryCache(boolean enabled) {
        this.setProperty("hibernate.cache.use_query_cache", enabled);
    }

    public void setQuerySubstitutions(String substitutions) {
        this.setProperty("hibernate.query.substitutions", substitutions);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

