/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.SessionImpl;

abstract class ScheduledCollectionAction
implements SessionImpl.Executable {
    private final CollectionPersister persister;
    private final Serializable id;
    private final SessionImplementor session;
    private CacheConcurrencyStrategy.SoftLock lock;

    public ScheduledCollectionAction(CollectionPersister persister, Serializable id, SessionImplementor session) throws CacheException {
        this.persister = persister;
        this.session = session;
        this.id = id;
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        if (this.persister.hasCache()) {
            this.persister.getCache().release(this.id, this.lock);
        }
    }

    public Serializable[] getPropertySpaces() {
        return new Serializable[]{this.persister.getCollectionSpace()};
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getId() {
        return this.id;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            this.lock = this.persister.getCache().lock(this.id);
        }
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            this.persister.getCache().evict(this.id);
        }
    }
}

