/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Lifecycle;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.Type;

public final class CacheEntry
implements Serializable {
    Object[] state;
    Class subclass;

    public Class getSubclass() {
        return this.subclass;
    }

    public CacheEntry(Object object, ClassPersister persister, SessionImplementor session) throws HibernateException {
        this.state = CacheEntry.disassemble(object, persister, session);
        this.subclass = object.getClass();
    }

    private static Object[] disassemble(Object object, ClassPersister persister, SessionImplementor session) throws HibernateException {
        Object[] values = persister.getPropertyValues(object);
        Type[] propertyTypes = persister.getPropertyTypes();
        for (int i = 0; i < values.length; ++i) {
            values[i] = propertyTypes[i].disassemble(values[i], session);
        }
        return values;
    }

    public Object[] assemble(Object instance, Serializable id, ClassPersister persister, Interceptor interceptor, SessionImplementor session) throws HibernateException {
        if (this.subclass != persister.getMappedClass()) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return CacheEntry.assemble(this.state, instance, id, persister, interceptor, session);
    }

    private static Object[] assemble(Object[] values, Object result, Serializable id, ClassPersister persister, Interceptor interceptor, SessionImplementor session) throws HibernateException {
        Type[] propertyTypes = persister.getPropertyTypes();
        Object[] assembledProps = new Object[propertyTypes.length];
        for (int i = 0; i < values.length; ++i) {
            assembledProps[i] = propertyTypes[i].assemble((Serializable)values[i], session, result);
        }
        interceptor.onLoad(result, id, values, persister.getPropertyNames(), propertyTypes);
        persister.setPropertyValues(result, assembledProps);
        if (persister.implementsLifecycle()) {
            ((Lifecycle)result).onLoad(session, id);
        }
        return assembledProps;
    }
}

