/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.QueryKey;
import net.sf.hibernate.cache.UpdateTimestampsCache;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryCache {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$QueryCache == null ? (class$net$sf$hibernate$cache$QueryCache = QueryCache.class$("net.sf.hibernate.cache.QueryCache")) : class$net$sf$hibernate$cache$QueryCache));
    private Cache queryCache;
    private UpdateTimestampsCache updateTimestampsCache;
    private final String regionName;
    static /* synthetic */ Class class$net$sf$hibernate$cache$QueryCache;

    public void clear() throws CacheException {
        this.queryCache.clear();
    }

    public QueryCache(CacheProvider provider, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) throws HibernateException {
        if (regionName == null) {
            regionName = (class$net$sf$hibernate$cache$QueryCache == null ? (class$net$sf$hibernate$cache$QueryCache = QueryCache.class$("net.sf.hibernate.cache.QueryCache")) : class$net$sf$hibernate$cache$QueryCache).getName();
        }
        log.info((Object)("starting query cache at region: " + regionName));
        this.queryCache = provider.buildCache(regionName, props);
        this.updateTimestampsCache = updateTimestampsCache;
        this.regionName = regionName;
    }

    public void put(QueryKey key, Type[] returnTypes, List result, SessionImplementor session) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching query results in region: " + this.regionName));
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        cacheable.add(new Long(session.getTimestamp()));
        for (int i = 0; i < result.size(); ++i) {
            if (returnTypes.length == 1) {
                cacheable.add(returnTypes[0].disassemble(result.get(i), session));
                continue;
            }
            cacheable.add(TypeFactory.disassemble((Object[])result.get(i), returnTypes, session));
        }
        this.queryCache.put(key, cacheable);
    }

    public List get(QueryKey key, Type[] returnTypes, Set spaces, SessionImplementor session) throws HibernateException {
        List cacheable;
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking cached query results in region: " + this.regionName));
        }
        if ((cacheable = (List)this.queryCache.get(key)) == null) {
            log.debug((Object)"query results were not found in cache");
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        Long timestamp = (Long)cacheable.get(0);
        if (!this.updateTimestampsCache.isUpToDate(spaces, timestamp)) {
            log.debug((Object)"cached query results were not up to date");
            return null;
        }
        log.debug((Object)"returning cached query results");
        for (int i = 1; i < cacheable.size(); ++i) {
            if (returnTypes.length == 1) {
                result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                continue;
            }
            result.add(TypeFactory.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
        }
        return result;
    }

    public void destroy() {
        try {
            this.queryCache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)("could not destroy query cache: " + this.regionName), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

