/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.support.AopUtils;
import org.springframework.metadata.Attributes;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class AttributesTransactionAttributeSource
implements TransactionAttributeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final Object NULL_TX_ATTRIBUTE = new Object();
    private final Attributes attributes;
    private HashMap cache = new HashMap();

    public AttributesTransactionAttributeSource(Attributes attributes) {
        this.attributes = attributes;
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        Object cacheKey = this.cacheKey(method, targetClass);
        Object cached = this.cache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_TX_ATTRIBUTE) {
                return null;
            }
            return (TransactionAttribute)cached;
        }
        TransactionAttribute txAtt = this.computeTransactionAttribute(method, targetClass);
        if (txAtt == null) {
            this.cache.put(cacheKey, NULL_TX_ATTRIBUTE);
        } else {
            this.cache.put(cacheKey, txAtt);
        }
        return txAtt;
    }

    private Object cacheKey(Method method, Class targetClass) {
        return targetClass + "" + System.identityHashCode(method);
    }

    protected TransactionAttribute computeTransactionAttribute(Method method, Class targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        TransactionAttribute txAtt = this.findTransactionAttribute(this.attributes.getAttributes(specificMethod));
        if (txAtt != null) {
            return txAtt;
        }
        txAtt = this.findTransactionAttribute(this.attributes.getAttributes(specificMethod.getDeclaringClass()));
        if (txAtt != null) {
            return txAtt;
        }
        if (specificMethod != method) {
            txAtt = this.findTransactionAttribute(this.attributes.getAttributes(method));
            if (txAtt != null) {
                return txAtt;
            }
            return this.findTransactionAttribute(this.attributes.getAttributes(method.getDeclaringClass()));
        }
        return null;
    }

    protected TransactionAttribute findTransactionAttribute(Collection atts) {
        if (atts == null) {
            return null;
        }
        TransactionAttribute txAttribute = null;
        Iterator itr = atts.iterator();
        while (itr.hasNext() && txAttribute == null) {
            Object att = itr.next();
            if (!(att instanceof TransactionAttribute)) continue;
            txAttribute = (TransactionAttribute)att;
        }
        if (txAttribute instanceof RuleBasedTransactionAttribute) {
            RuleBasedTransactionAttribute rbta = (RuleBasedTransactionAttribute)txAttribute;
            LinkedList l = new LinkedList();
            Iterator itr2 = atts.iterator();
            while (itr2.hasNext()) {
                Object att = itr2.next();
                if (!(att instanceof RollbackRuleAttribute)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found RollbackRule " + att));
                }
                l.add(att);
            }
            rbta.setRollbackRules(l);
        }
        return txAttribute;
    }
}

