/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.SQLErrorCodes;

public class SQLErrorCodesFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/springframework/jdbc/support/sql-error-codes.xml";
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private Map rdbmsErrorCodes;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodes;

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        try {
            String path = SQL_ERROR_CODE_OVERRIDE_PATH;
            Resource resource = this.loadResource(path);
            if (!(resource != null && resource.exists() || (resource = this.loadResource(path = SQL_ERROR_CODE_DEFAULT_PATH)) != null && resource.exists())) {
                throw new BeanDefinitionStoreException("Unable to locate file [org/springframework/jdbc/support/sql-error-codes.xml]");
            }
            XmlBeanFactory bf = new XmlBeanFactory(resource);
            String[] rdbmsNames = bf.getBeanDefinitionNames(class$org$springframework$jdbc$support$SQLErrorCodes == null ? (class$org$springframework$jdbc$support$SQLErrorCodes = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodes")) : class$org$springframework$jdbc$support$SQLErrorCodes);
            this.rdbmsErrorCodes = new HashMap(rdbmsNames.length);
            for (int i = 0; i < rdbmsNames.length; ++i) {
                SQLErrorCodes ec = (SQLErrorCodes)bf.getBean(rdbmsNames[i]);
                if (ec.getBadSqlGrammarCodes() == null) {
                    ec.setBadSqlGrammarCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getBadSqlGrammarCodes());
                }
                if (ec.getDataIntegrityViolationCodes() == null) {
                    ec.setDataIntegrityViolationCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getDataIntegrityViolationCodes());
                }
                if (ec.getDatabaseProductName() == null) {
                    this.rdbmsErrorCodes.put(rdbmsNames[i], ec);
                    continue;
                }
                this.rdbmsErrorCodes.put(ec.getDatabaseProductName(), ec);
            }
            this.logger.info((Object)("SQLErrorCodes loaded: " + this.rdbmsErrorCodes.keySet()));
        }
        catch (BeanDefinitionStoreException be) {
            this.logger.warn((Object)("Error loading error codes from config file. Message: " + be.getMessage()));
            this.rdbmsErrorCodes = new HashMap(0);
        }
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource ds) {
        this.logger.info((Object)"Looking up default SQLErrorCodes for DataSource");
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection(ds);
        }
        catch (DataAccessException ex) {
            this.logger.warn((Object)"Cannot get connection from database to get metadata when trying to create exception translator", (Throwable)ex);
        }
        if (con != null) {
            try {
                DatabaseMetaData dbmd = con.getMetaData();
                if (dbmd != null) {
                    String dbName = dbmd.getDatabaseProductName();
                    String driverVersion = dbmd.getDriverVersion();
                    if (dbName != null && dbName.startsWith("DB2/")) {
                        dbName = "DB2";
                    }
                    if (dbName != null) {
                        this.logger.info((Object)("Database Product Name is " + dbName));
                        this.logger.info((Object)("Driver Version is " + driverVersion));
                        SQLErrorCodes sec = (SQLErrorCodes)this.rdbmsErrorCodes.get(dbName);
                        if (sec != null) {
                            SQLErrorCodes sQLErrorCodes = sec;
                            return sQLErrorCodes;
                        }
                        this.logger.info((Object)("Error Codes for " + dbName + " not found"));
                    }
                } else {
                    this.logger.warn((Object)"Null meta data from connection when trying to create exception translator");
                }
            }
            catch (SQLException se) {
                this.logger.warn((Object)"Could not read database meta data for exception translator", (Throwable)se);
            }
            finally {
                DataSourceUtils.closeConnectionIfNecessary(con, ds);
            }
        }
        return new SQLErrorCodes();
    }

    public SQLErrorCodes getErrorCodes(String dbName) {
        SQLErrorCodes sec = (SQLErrorCodes)this.rdbmsErrorCodes.get(dbName);
        if (sec == null) {
            sec = new SQLErrorCodes();
        }
        return sec;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

