/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.jdbc.datasource.SmartDataSource;

public class DriverManagerDataSource
extends AbstractDataSource
implements SmartDataSource {
    private String driverClassName = "";
    private String url = "";
    private String username = "";
    private String password = "";

    public DriverManagerDataSource() {
    }

    public DriverManagerDataSource(String driverClassName, String url, String username, String password) throws CannotGetJdbcConnectionException {
        this.setDriverClassName(driverClassName);
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public void setDriverClassName(String driverClassName) throws CannotGetJdbcConnectionException {
        this.driverClassName = driverClassName;
        try {
            Class.forName(this.driverClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new CannotGetJdbcConnectionException("Could not load JDBC driver class [" + this.driverClassName + "]", ex);
        }
        this.logger.info((Object)("Loaded JDBC driver: " + this.driverClassName));
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean shouldClose(Connection conn) {
        return true;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriverManager();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriverManager(this.url, username, password);
    }

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return this.getConnectionFromDriverManager(this.url, this.username, this.password);
    }

    protected Connection getConnectionFromDriverManager(String url, String username, String password) throws SQLException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating new JDBC connection to [" + url + "]"));
        }
        return DriverManager.getConnection(url, username, password);
    }
}

