/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;

public class JobStoreCMT
extends JobStoreSupport {
    protected String nonManagedTxDsName;
    protected boolean dontSetNonManagedTXConnectionAutoCommitFalse = false;

    public void setNonManagedTXDataSource(String nonManagedTxDsName) {
        this.nonManagedTxDsName = nonManagedTxDsName;
    }

    public String getNonManagedTXDataSource() {
        return this.nonManagedTxDsName;
    }

    public boolean isDontSetNonManagedTXConnectionAutoCommitFalse() {
        return this.dontSetNonManagedTXConnectionAutoCommitFalse;
    }

    public void setDontSetNonManagedTXConnectionAutoCommitFalse(boolean b) {
        this.dontSetNonManagedTXConnectionAutoCommitFalse = b;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        if (this.nonManagedTxDsName == null) {
            throw new SchedulerConfigException("Non-ManagedTX DataSource name not set!");
        }
        this.setUseDBLocks(true);
        super.initialize(loadHelper, signaler);
        this.getLog().info((Object)"JobStoreCMT initialized.");
    }

    /*
     * Loose catch block
     */
    protected void recoverJobs() throws JobPersistenceException {
        block19: {
            boolean transOwner;
            Connection conn;
            block20: {
                conn = null;
                transOwner = false;
                conn = this.getNonManagedTXConnection();
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.recoverJobs(conn);
                conn.commit();
                Object var7_3 = null;
                if (conn == null) break block19;
                if (!transOwner) break block20;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block19;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error recovering jobs: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (conn != null) {
                    if (transOwner) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                        }
                        catch (LockException le) {
                            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        block19: {
            boolean transOwner;
            Connection conn;
            block20: {
                conn = null;
                transOwner = false;
                conn = this.getNonManagedTXConnection();
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.cleanVolatileTriggerAndJobs(conn);
                conn.commit();
                Object var7_3 = null;
                if (conn == null) break block19;
                if (!transOwner) break block20;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block19;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error cleaning volatile data: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (conn != null) {
                    if (transOwner) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                        }
                        catch (LockException le) {
                            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn;
        block10: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                if (newJob.isVolatile() && !newTrigger.isVolatile()) {
                    JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
                    jpe.setErrorCode(100);
                    throw jpe;
                }
                this.storeJob(conn, ctxt, newJob, false);
                this.storeTrigger(conn, ctxt, newTrigger, false, "WAITING", false, false);
                Object var8_7 = null;
                if (!transOwner) break block10;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.storeJob(conn, ctxt, newJob, replaceExisting);
                Object var7_6 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                bl = this.removeJob(conn, ctxt, jobName, groupName, true);
                Object var8_7 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {}
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        JobDetail jobDetail;
        Connection conn = this.getConnection();
        try {
            jobDetail = this.retrieveJob(conn, ctxt, jobName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return jobDetail;
    }

    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.storeTrigger(conn, ctxt, newTrigger, replaceExisting, "WAITING", false, false);
                Object var7_6 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                bl = this.removeTrigger(conn, ctxt, triggerName, groupName);
                Object var8_7 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {}
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        boolean bl;
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                bl = this.replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
                Object var9_8 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {}
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Trigger trigger;
        Connection conn = this.getConnection();
        try {
            trigger = this.retrieveTrigger(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return trigger;
    }

    public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            bl = this.removeCalendar(conn, ctxt, calName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Calendar calendar;
        Connection conn = this.getConnection();
        try {
            calendar = this.retrieveCalendar(conn, ctxt, calName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return calendar;
    }

    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getNumberOfJobs(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getNumberOfTriggers(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getNumberOfCalendars(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getJobNames(conn, ctxt, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getTriggerNames(conn, ctxt, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getJobGroupNames(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getTriggerGroupNames(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getCalendarNames(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Trigger[] triggerArray;
        Connection conn = this.getConnection();
        try {
            triggerArray = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return triggerArray;
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getTriggerState(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.pauseTrigger(conn, ctxt, triggerName, groupName);
                Object var7_6 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.pauseTriggerGroup(conn, ctxt, groupName);
                Object var6_5 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn;
        block10: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
                int j = 0;
                while (j < triggers.length) {
                    this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                    ++j;
                }
                Object var9_8 = null;
                if (!transOwner) break block10;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn;
        block11: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                String[] jobNames = this.getJobNames(conn, ctxt, groupName);
                int i = 0;
                while (i < jobNames.length) {
                    Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                    int j = 0;
                    while (j < triggers.length) {
                        this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                        ++j;
                    }
                    ++i;
                }
                Object var10_9 = null;
                if (!transOwner) break block11;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.resumeTrigger(conn, ctxt, triggerName, groupName);
                Object var7_6 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.resumeTriggerGroup(conn, ctxt, groupName);
                Object var6_5 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn;
        block10: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
                int j = 0;
                while (j < triggers.length) {
                    this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                    ++j;
                }
                Object var9_8 = null;
                if (!transOwner) break block10;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn;
        block11: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                String[] jobNames = this.getJobNames(conn, ctxt, groupName);
                int i = 0;
                while (i < jobNames.length) {
                    Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                    int j = 0;
                    while (j < triggers.length) {
                        this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                        ++j;
                    }
                    ++i;
                }
                Object var10_9 = null;
                if (!transOwner) break block11;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.pauseAll(conn, ctxt);
                Object var5_4 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn;
        block9: {
            conn = this.getConnection();
            boolean transOwner = false;
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.resumeAll(conn, ctxt);
                Object var5_4 = null;
                if (!transOwner) break block9;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger acquireNextTrigger(SchedulingContext ctxt) throws JobPersistenceException {
        block16: {
            conn = null;
            transOwner = false;
            try {
                try {
                    conn = this.getNonManagedTXConnection();
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                    trigger = this.acquireNextTrigger(conn, ctxt);
                    conn.commit();
                    var5_6 = trigger;
                    var8_9 = null;
                    if (conn == null) return var5_6;
                    if (!transOwner) break block16;
                }
                catch (JobPersistenceException e) {
                    try {
                        if (conn == null) throw e;
                        conn.rollback();
                        throw e;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
                        conn.rollback();
                        throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
                }
            }
            catch (Throwable var7_14) {
                var8_10 = null;
                if (conn == null) throw var7_14;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                    throw var7_14;
                }
                catch (SQLException ignore) {
                    throw var7_14;
                }
            }
            ** try [egrp 4[TRYBLOCK] [5 : 137->153)] { 
lbl51:
            // 1 sources

            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            break block16;
lbl53:
            // 1 sources

            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        ** try [egrp 5[TRYBLOCK] [6 : 189->198)] { 
lbl57:
        // 1 sources

        conn.close();
        return var5_6;
lbl59:
        // 1 sources

        catch (SQLException ignore) {
            // empty catch block
        }
        return var5_6;
    }

    /*
     * Loose catch block
     */
    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        block19: {
            boolean transOwner;
            Connection conn;
            block20: {
                conn = null;
                transOwner = false;
                conn = this.getNonManagedTXConnection();
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.releaseAcquiredTrigger(conn, ctxt, trigger);
                conn.commit();
                Object var9_5 = null;
                if (conn == null) break block19;
                if (!transOwner) break block20;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block19;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error releasing acquired trigger: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                if (conn != null) {
                    if (transOwner) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                        }
                        catch (LockException le) {
                            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        block20: {
            conn = null;
            transOwner = false;
            try {
                try {
                    conn = this.getNonManagedTXConnection();
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                    tfb = null;
                    err = null;
                    try {
                        tfb = this.triggerFired(conn, ctxt, trigger);
                    }
                    catch (JobPersistenceException jpe) {
                        if (jpe.getErrorCode() != 410) {
                            throw jpe;
                        }
                        err = jpe;
                    }
                    if (err != null) {
                        throw err;
                    }
                    conn.commit();
                    jpe = tfb;
                    var9_13 = null;
                    if (conn == null) return jpe;
                    if (!transOwner) break block20;
                }
                catch (JobPersistenceException e) {
                    try {
                        if (conn == null) throw e;
                        conn.rollback();
                        throw e;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                        conn.rollback();
                        throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable var8_17) {
                var9_14 = null;
                if (conn == null) throw var8_17;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                    throw var8_17;
                }
                catch (SQLException ignore) {
                    throw var8_17;
                }
            }
            ** try [egrp 5[TRYBLOCK] [6 : 178->194)] { 
lbl61:
            // 1 sources

            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            break block20;
lbl63:
            // 1 sources

            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        ** try [egrp 6[TRYBLOCK] [7 : 230->239)] { 
lbl67:
        // 1 sources

        conn.close();
        return jpe;
lbl69:
        // 1 sources

        catch (SQLException ignore) {
            // empty catch block
        }
        return jpe;
    }

    /*
     * Loose catch block
     */
    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        block19: {
            boolean transOwner;
            Connection conn;
            block20: {
                conn = null;
                transOwner = false;
                conn = this.getNonManagedTXConnection();
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
                conn.commit();
                Object var11_7 = null;
                if (conn == null) break block19;
                if (!transOwner) break block20;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block19;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (conn != null) {
                    if (transOwner) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                        }
                        catch (LockException le) {
                            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doRecoverMisfires() throws JobPersistenceException {
        block18: {
            conn = null;
            transOwner = false;
            moreToDo = false;
            try {
                try {
                    conn = this.getNonManagedTXConnection();
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                    try {
                        moreToDo = this.recoverMisfiredJobs(conn);
                    }
                    catch (Exception e) {
                        throw new JobPersistenceException(e.getMessage(), e);
                    }
                    conn.commit();
                    e = moreToDo;
                    var8_7 = null;
                    if (conn == null) return e;
                    if (!transOwner) break block18;
                }
                catch (JobPersistenceException e) {
                    try {
                        if (conn == null) throw e;
                        conn.rollback();
                        throw e;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                        conn.rollback();
                        throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable var7_14) {
                var8_8 = null;
                if (conn == null) throw var7_14;
                if (transOwner) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                }
                try {
                    conn.close();
                    throw var7_14;
                }
                catch (SQLException ignore) {
                    throw var7_14;
                }
            }
            ** try [egrp 5[TRYBLOCK] [6 : 156->172)] { 
lbl56:
            // 1 sources

            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            break block18;
lbl58:
            // 1 sources

            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        ** try [egrp 6[TRYBLOCK] [7 : 208->217)] { 
lbl62:
        // 1 sources

        conn.close();
        return e;
lbl64:
        // 1 sources

        catch (SQLException ignore) {
            // empty catch block
        }
        return e;
    }

    /*
     * Loose catch block
     */
    protected boolean doCheckin() throws JobPersistenceException {
        boolean recovered;
        block25: {
            LockException le22;
            boolean transStateOwner;
            boolean transOwner;
            Connection conn;
            block26: {
                conn = null;
                transOwner = false;
                transStateOwner = false;
                recovered = false;
                conn = this.getNonManagedTXConnection();
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
                transStateOwner = true;
                List failedRecords = this.clusterCheckIn(conn);
                if (failedRecords.size() > 0) {
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                    this.clusterRecover(conn, failedRecords);
                    recovered = true;
                }
                conn.commit();
                Object var9_7 = null;
                if (conn == null) break block25;
                if (!transOwner) break block26;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le22) {
                    this.getLog().error((Object)("Error returning lock: " + le22.getMessage()), (Throwable)le22);
                }
            }
            if (transStateOwner) {
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
                }
                catch (LockException le22) {
                    this.getLog().error((Object)("Error returning lock: " + le22.getMessage()), (Throwable)le22);
                }
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block25;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (conn != null) {
                    LockException le22;
                    if (transOwner) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                        }
                        catch (LockException le22) {
                            this.getLog().error((Object)("Error returning lock: " + le22.getMessage()), (Throwable)le22);
                        }
                    }
                    if (transStateOwner) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
                        }
                        catch (LockException le22) {
                            this.getLog().error((Object)("Error returning lock: " + le22.getMessage()), (Throwable)le22);
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.firstCheckIn = false;
        return recovered;
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getNonManagedTXDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getNonManagedTXDataSource() + "'");
            }
            if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                conn.setAutoCommit(false);
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + e.toString(), e, 499);
        }
    }
}

