/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.Random;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private Object pauseLock = new Object();
    private Object idleLock = new Object();
    private boolean signaled;
    private boolean paused;
    private boolean halted;
    private SchedulingContext ctxt = null;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private long dbFailureRetryInterval = 15000L;

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt) {
        this(qs, qsRsrcs, ctxt, false, 5);
    }

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio) {
        super(qs.getSchedulerThreadGroup(), "QuartzSchedulerThread");
        this.qs = qs;
        this.qsRsrcs = qsRsrcs;
        this.ctxt = ctxt;
        this.setDaemon(setDaemon);
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = false;
        this.start();
    }

    void setIdleWaitTime(long waitTime) {
        this.idleWaitTime = waitTime;
        this.idleWaitVariablness = (int)((double)waitTime * 0.2);
    }

    private long getDbFailureRetryInterval() {
        return this.dbFailureRetryInterval;
    }

    public void setDbFailureRetryInterval(long dbFailureRetryInterval) {
        this.dbFailureRetryInterval = dbFailureRetryInterval;
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    void togglePause(boolean pause) {
        Object object = this.pauseLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange();
            } else {
                this.pauseLock.notify();
            }
        }
    }

    void halt() {
        Object object = this.pauseLock;
        synchronized (object) {
            this.halted = true;
            if (this.paused) {
                this.pauseLock.notify();
            } else {
                this.signalSchedulingChange();
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    void signalSchedulingChange() {
        this.signaled = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.halted) {
            int numPauses;
            long spinInterval;
            long now;
            Object object = this.pauseLock;
            synchronized (object) {
                while (this.paused && !this.halted) {
                    try {
                        this.pauseLock.wait(100L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                if (this.halted) {
                    break;
                }
            }
            Trigger trigger = null;
            Object jobDetail = null;
            Object cal = null;
            boolean idleWait = true;
            try {
                trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt);
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
            }
            if (trigger != null) {
                now = System.currentTimeMillis();
                long triggerTime = trigger.getNextFireTime().getTime();
                long timeUntilTrigger = triggerTime - now;
                spinInterval = 10L;
                if (timeUntilTrigger <= this.idleWaitTime) {
                    Object v0;
                    try {
                        numPauses = (int)(timeUntilTrigger / spinInterval);
                        while (true) {
                            if (numPauses < 0 || this.signaled) {
                                v0 = null;
                                break;
                            }
                            try {
                                Thread.sleep(spinInterval);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            now = System.currentTimeMillis();
                            timeUntilTrigger = triggerTime - now;
                            numPauses = (int)(timeUntilTrigger / spinInterval);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_19;
                        v0 = var17_19 = null;
                    }
                    if (!this.signaled) {
                        // JSR Ret
                    }
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (JobPersistenceException jpe) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    this.signaled = false;
                    continue;
                }
                try {
                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                }
                catch (JobPersistenceException jpe) {
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                    this.releaseTriggerRetryLoop(trigger);
                }
                idleWait = true;
            }
            now = System.currentTimeMillis();
            long waitTime = now + this.getRandomizedIdleWaitTime();
            long timeUntilContinue = waitTime - now;
            spinInterval = 10L;
            numPauses = (int)(timeUntilContinue / spinInterval);
            while (idleWait && numPauses > 0 && !this.signaled) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
                timeUntilContinue = waitTime - now;
                numPauses = (int)(timeUntilContinue / spinInterval);
            }
            this.signaled = false;
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    public void releaseTriggerRetryLoop(Trigger trigger) {
        while (!this.halted) {
            try {
                Thread.sleep(this.getDbFailureRetryInterval());
                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                break;
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

