/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import xjavadoc.Token;
import xjavadoc.XDoc;
import xjavadoc.XTag;

public class XDocTest
extends TestCase {
    private XDoc doc;

    public XDocTest(String name) {
        super(name);
    }

    public void setUp() throws IOException {
        String javadoc = "/********************** This is in the doc too      \n * JUnit test for\n   * JavaDocReader.    \n   * This is sentence number two.   \n     * @ejb:bla * bla\n *   @param what about\n * this one?\n *Or this\n     one?\n * @oh dear=\"we\" should=\"go to bed\"\n */";
        Token token = Token.newToken(0);
        token.image = javadoc;
        this.doc = new XDoc(token, null);
    }

    public void testFirstSentence() throws IOException {
        Assert.assertEquals((String)"This is in the doc too JUnit test for JavaDocReader.", (String)this.doc.getFirstSentence());
        Assert.assertEquals((String)"This is in the doc too JUnit test for JavaDocReader. This is sentence number two.", (String)this.doc.getCommentText());
    }

    public void testCommentChange() throws IOException {
        this.doc.setCommentText("foo bar baz blurge. And this is second sentence");
        Assert.assertEquals((String)"foo bar baz blurge.", (String)this.doc.getFirstSentence());
        Assert.assertEquals((String)"foo bar baz blurge. And this is second sentence", (String)this.doc.getCommentText());
    }

    public void testTagCreationAndRemoval() throws IOException {
        this.doc.addTag("foo:bar", "blurge=\"bang\" baz=\"blabla\" what's up?");
        Assert.assertTrue((boolean)this.doc.hasTag("foo:bar"));
        this.doc.removeTag(this.doc.getTag("foo:bar"));
        Assert.assertTrue((!this.doc.hasTag("foo:bar") ? 1 : 0) != 0);
    }

    public void testTagChange() throws IOException {
        this.doc.addTag("foo:bar", "blurge=\"bang\" baz=\"blabla\" what's up?");
        Assert.assertEquals((String)this.doc.getTagAttributeValue("foo:bar", "blurge"), (String)"bang");
        XTag tag = this.doc.getTag("foo:bar");
        tag.setAttribute("blurge", "foo");
        Assert.assertEquals((String)tag.getAttributeValue("blurge"), (String)"foo");
        tag.setAttribute("foo", "bar");
        Assert.assertEquals((String)this.doc.getTagAttributeValue("foo:bar", "blurge"), (String)"foo");
        Assert.assertEquals((String)this.doc.getTagAttributeValue("foo:bar", "foo"), (String)"bar");
    }
}

