/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;

public class AttributeIndex {
    private final HashMap index = new HashMap();

    public AttributeIndex(ClassLoader cl) throws Exception {
        Enumeration<URL> enumeration = cl.getResources("META-INF/attrs.index");
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            this.loadFromURL(url);
        }
    }

    private void addClass(String attributeClass, String clazz) {
        HashSet<String> coll = (HashSet<String>)this.index.get(attributeClass);
        if (coll == null) {
            coll = new HashSet<String>();
            this.index.put(attributeClass, coll);
        }
        coll.add(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromURL(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String currentAttributeClass = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("Attribute: ")) {
                    currentAttributeClass = line.substring("Attribute: ".length()).trim();
                    continue;
                }
                if (!line.startsWith("Class: ")) continue;
                String className = line.substring("Class: ".length()).trim();
                this.addClass(currentAttributeClass, className);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            br.close();
            throw throwable;
        }
        br.close();
    }

    public Collection getClassesWithAttribute(String attributeClass) {
        if (this.index.containsKey(attributeClass)) {
            return (Collection)this.index.get(attributeClass);
        }
        return Collections.EMPTY_SET;
    }

    public Collection getClassesWithAttribute(Class attributeClass) {
        return this.getClassesWithAttribute(attributeClass.getName());
    }
}

