/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.datasource;

import com.ibatis.db.sqlmap.SqlMapException;
import com.ibatis.db.sqlmap.datasource.DataSourceFactory;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class DbcpDataSourceFactory
implements DataSourceFactory {
    private DataSource dataSource;
    private String[] expectedProperties = new String[]{"JDBC.Driver", "JDBC.ConnectionURL", "JDBC.Username", "JDBC.Password", "Pool.ValidationQuery", "Pool.MaximumActiveConnections", "Pool.MaximumIdleConnections", "Pool.MaximumWait", "Pool.LogAbandoned", "Pool.RemoveAbandoned", "Pool.RemoveAbandonedTimeout"};

    public void initialize(Map map) {
        try {
            String string = (String)map.get("JDBC.Driver");
            String string2 = (String)map.get("JDBC.ConnectionURL");
            String string3 = (String)map.get("JDBC.Username");
            String string4 = (String)map.get("JDBC.Password");
            String string5 = (String)map.get("Pool.ValidationQuery");
            String string6 = (String)map.get("Pool.MaximumActiveConnections");
            String string7 = (String)map.get("Pool.MaximumIdleConnections");
            String string8 = (String)map.get("Pool.MaximumWait");
            String string9 = (String)map.get("Pool.RemoveAbandoned");
            String string10 = (String)map.get("Pool.RemoveAbandonedTimeout");
            String string11 = (String)map.get("Pool.LogAbandoned");
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setUrl(string2);
            basicDataSource.setDriverClassName(string);
            basicDataSource.setUsername(string3);
            basicDataSource.setPassword(string4);
            if (this.notEmpty(string5)) {
                basicDataSource.setValidationQuery(string5);
            }
            if (this.notEmpty(string6)) {
                basicDataSource.setMaxActive(Integer.parseInt(string6));
            }
            if (this.notEmpty(string7)) {
                basicDataSource.setMaxIdle(Integer.parseInt(string7));
            }
            if (this.notEmpty(string8)) {
                basicDataSource.setMaxWait((long)Integer.parseInt(string8));
            }
            if (this.notEmpty(string10)) {
                basicDataSource.setRemoveAbandonedTimeout(Integer.parseInt(string10));
            }
            if (this.notEmpty(string9)) {
                basicDataSource.setRemoveAbandoned("true".equals(string9));
            }
            if (this.notEmpty(string11)) {
                basicDataSource.setLogAbandoned("true".equals(string11));
            }
            this.dataSource = basicDataSource;
        }
        catch (Exception exception) {
            throw new SqlMapException("Error initializing DbcpDataSourceFactory.  Cause: " + exception, exception);
        }
    }

    private boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String[] getExpectedProperties() {
        return this.expectedProperties;
    }
}

