/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import com.oreilly.servlet.multipart.FileRenamePolicy;
import com.oreilly.servlet.multipart.MacBinaryDecoderOutputStream;
import com.oreilly.servlet.multipart.Part;
import com.oreilly.servlet.multipart.PartInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;

public class FilePart
extends Part {
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;
    private FileRenamePolicy policy;

    FilePart(String name, ServletInputStream in, String boundary, String contentType, String fileName, String filePath) throws IOException {
        super(name);
        this.fileName = fileName;
        this.filePath = filePath;
        this.contentType = contentType;
        this.partInput = new PartInputStream(in, boundary);
    }

    public void setRenamePolicy(FileRenamePolicy policy) {
        this.policy = policy;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long writeTo(File fileOrDirectory) throws IOException {
        long written = 0L;
        OutputStream fileOut = null;
        try {
            if (this.fileName != null) {
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                if (this.policy != null) {
                    file = this.policy.rename(file);
                    this.fileName = file.getName();
                }
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
            Object var7_5 = null;
            if (fileOut == null) return written;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fileOut == null) throw throwable;
            fileOut.close();
            throw throwable;
        }
        fileOut.close();
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            size = this.write(out);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    long write(OutputStream out) throws IOException {
        int read;
        if (this.contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            void var4_4;
            out.write(buf, 0, (int)var4_4);
            size += (long)var4_4;
        }
        return size;
    }

    public boolean isFile() {
        return true;
    }
}

