/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import org.easymock.MockControl;
import org.easymock.ParameterMatcher;
import org.easymock.internal.IBehavior;
import org.easymock.internal.IMockControlState;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;

public class RecordState
implements IMockControlState {
    private MethodCall lastMethodCall;
    private boolean lastMethodCallUsed = true;
    private IBehavior behavior;

    public RecordState(IBehavior behavior) {
        this.behavior = behavior;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        this.closeVoidMethod();
        this.lastMethodCall = new MethodCall(method, args);
        this.lastMethodCallUsed = false;
        return RecordState.emptyReturnValueFor(method);
    }

    public void replay() {
        this.closeVoidMethod();
    }

    public void verify() {
        throw new IllegalStateException("calling verify is not allowed in record state");
    }

    public void setDefaultMatcher(ParameterMatcher matcher) {
        this.behavior.setDefaultMatcher(matcher);
    }

    public void setMatcher(ParameterMatcher matcher) {
        this.requireMethodCall("matcher");
        this.behavior.setMatcher(this.lastMethodCall.getMethod(), matcher);
    }

    public void setVoidCallable(Range count) {
        this.requireMethodCall("void callable");
        this.requireVoidMethod();
        this.behavior.addExpected(this.lastMethodCall, Result.valueResult(null), count);
        this.lastMethodCallUsed = true;
    }

    public void setThrowable(Throwable throwable, Range count) {
        this.requireMethodCall("Throwable");
        this.requireValidThrowable(throwable);
        this.behavior.addExpected(this.lastMethodCall, Result.throwResult(throwable), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(long value, Range count) {
        this.requireMethodCall("return value");
        Class<?> returnType = this.lastMethodCall.getMethod().getReturnType();
        Object primitiveReturnValue = this.createNumberObject(value, returnType);
        this.behavior.addExpected(this.lastMethodCall, Result.valueResult(primitiveReturnValue), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(boolean value, Range count) {
        this.requireMethodCall("return value");
        this.requireReturnType(Boolean.TYPE);
        this.behavior.addExpected(this.lastMethodCall, Result.valueResult(value ? Boolean.TRUE : Boolean.FALSE), count);
        this.lastMethodCallUsed = true;
    }

    private void requireReturnType(Class clazz) {
        if (!this.lastMethodCall.getMethod().getReturnType().equals(clazz)) {
            throw new IllegalStateException("incompatible return value type");
        }
    }

    public void setReturnValue(float value, Range count) {
        this.requireMethodCall("return value");
        this.requireReturnType(Float.TYPE);
        this.behavior.addExpected(this.lastMethodCall, Result.valueResult(new Float(value)), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(double value, Range count) {
        this.requireMethodCall("return value");
        this.requireReturnType(Double.TYPE);
        this.behavior.addExpected(this.lastMethodCall, Result.valueResult(new Double(value)), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(Object value, Range count) {
        this.requireMethodCall("return value");
        this.requireAssignable(value);
        this.behavior.addExpected(this.lastMethodCall, Result.valueResult(value), count);
        this.lastMethodCallUsed = true;
    }

    public void setDefaultThrowable(Throwable throwable) {
        this.requireMethodCall("default Throwable");
        this.requireValidThrowable(throwable);
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.throwResult(throwable));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultVoidCallable() {
        this.requireMethodCall("default void callable");
        this.requireVoidMethod();
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.valueResult(null));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(long value) {
        this.requireMethodCall("default return value");
        Class<?> returnType = this.lastMethodCall.getMethod().getReturnType();
        Object primitiveReturnValue = this.createNumberObject(value, returnType);
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.valueResult(primitiveReturnValue));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(boolean value) {
        this.requireMethodCall("default return value");
        this.requireReturnType(Boolean.TYPE);
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.valueResult(value ? Boolean.TRUE : Boolean.FALSE));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(float value) {
        this.requireMethodCall("default return value");
        this.requireReturnType(Float.TYPE);
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.valueResult(new Float(value)));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(double value) {
        this.requireMethodCall("default return value");
        this.requireReturnType(Double.TYPE);
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.valueResult(new Double(value)));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(Object value) {
        this.requireMethodCall("default return value");
        this.requireAssignable(value);
        this.behavior.setDefaultBehavior(this.lastMethodCall.getMethod(), Result.valueResult(value));
        this.lastMethodCallUsed = true;
    }

    private Object createNumberObject(long value, Class returnType) {
        if (returnType.equals(Byte.TYPE)) {
            return new Byte((byte)value);
        }
        if (returnType.equals(Short.TYPE)) {
            return new Short((short)value);
        }
        if (returnType.equals(Character.TYPE)) {
            return new Character((char)value);
        }
        if (returnType.equals(Integer.TYPE)) {
            return new Integer((int)value);
        }
        if (returnType.equals(Long.TYPE)) {
            return new Long(value);
        }
        throw new IllegalStateException("incompatible return value type");
    }

    private void closeVoidMethod() {
        if (this.lastMethodCallUsed) {
            return;
        }
        try {
            this.setVoidCallable(MockControl.ONE);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("missing behavior definition for last method call on the mock");
        }
    }

    static Object emptyReturnValueFor(Method method) {
        Class<?> type = method.getReturnType();
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Void.TYPE) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return new Boolean(false);
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        throw new RuntimeException("EasyMock bug: no return value generated!");
    }

    private void requireMethodCall(String failMessage) {
        if (this.lastMethodCall == null) {
            throw new IllegalStateException("method call on the mock needed before setting " + failMessage);
        }
    }

    private void requireAssignable(Object returnValue) {
        if (this.lastMethodIsVoidMethod()) {
            throw new IllegalStateException("void method cannot return a value");
        }
        if (returnValue == null) {
            return;
        }
        Class<?> returnedType = this.lastMethodCall.getMethod().getReturnType();
        if (!returnedType.isAssignableFrom(returnValue.getClass())) {
            throw new IllegalStateException("incompatible return value type");
        }
    }

    private void requireValidThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("null cannot be thrown");
        }
        if (this.isValidThrowable(throwable)) {
            return;
        }
        throw new IllegalArgumentException("last method called on mock cannot throw " + throwable.getClass().getName());
    }

    private void requireVoidMethod() {
        if (!this.lastMethodIsVoidMethod()) {
            throw new IllegalStateException("last method called on mock is not a void method");
        }
    }

    private boolean lastMethodIsVoidMethod() {
        Class<?> returnType = this.lastMethodCall.getMethod().getReturnType();
        boolean isVoid = returnType.equals(Void.TYPE);
        return isVoid;
    }

    private boolean isValidThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return true;
        }
        if (throwable instanceof Error) {
            return true;
        }
        Class<?>[] exceptions = this.lastMethodCall.getMethod().getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        int i = 0;
        while (i < exceptions.length) {
            if (exceptions[i].isAssignableFrom(throwableClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

