/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.MockControl;
import org.easymock.ParameterMatcher;
import org.easymock.internal.IBehavior;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Result;

public abstract class AbstractBehavior
implements IBehavior {
    private boolean defaultMatcherSet;
    private Map matchers = new HashMap();
    private Map defaultBehaviors = new HashMap();
    private ParameterMatcher defaultMatcher;

    public void setDefaultMatcher(ParameterMatcher defaultMatcher) {
        if (this.defaultMatcherSet) {
            throw new IllegalStateException("default matcher can only be set once directly after creation of the MockControl");
        }
        this.defaultMatcher = defaultMatcher;
        this.defaultMatcherSet = true;
    }

    private ParameterMatcher getDefaultMatcher() {
        if (!this.defaultMatcherSet) {
            this.setDefaultMatcher(MockControl.EQUALS_MATCHER);
        }
        return this.defaultMatcher;
    }

    public void setDefaultBehavior(Method method, Result result) {
        this.defaultBehaviors.put(method, result);
    }

    Result getDefaultBehavior(Method method) {
        return (Result)this.defaultBehaviors.get(method);
    }

    public void setMatcher(Method method, ParameterMatcher matcher) {
        if (this.matchers.containsKey(method)) {
            throw new IllegalStateException("For method " + method + ", Matcher " + matcher + " has already been set.");
        }
        this.matchers.put(method, matcher);
    }

    ParameterMatcher getMatcher(Method method) {
        if (!this.matchers.containsKey(method)) {
            this.matchers.put(method, this.getDefaultMatcher());
        }
        return (ParameterMatcher)this.matchers.get(method);
    }

    public final Result addActual(Method method, Object[] parameters) {
        try {
            return this.addActual2(method, parameters);
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError("\n  Unexpected method call " + new MethodCall(method, parameters).toString(this.getMatcher(method)) + ":" + e.getMessage());
        }
    }

    public final void verify() {
        try {
            this.verify2();
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError("\n  Expectation failure on verify:" + e.getMessage());
        }
    }

    protected abstract void verify2();

    protected abstract Result addActual2(Method var1, Object[] var2);
}

