/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.easymock.AbstractMatcher;
import org.easymock.ParameterMatcher;
import org.easymock.internal.IBehavior;
import org.easymock.internal.IBehaviorFactory;
import org.easymock.internal.IMockControlBase;
import org.easymock.internal.IMockControlState;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.JavaProxyFactory;
import org.easymock.internal.NiceBehavior;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.OrderedBehavior;
import org.easymock.internal.PlayState;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.UnorderedBehavior;

public class MockControl
implements IMockControlBase {
    protected static final IBehaviorFactory NICE_BEHAVIOR_FACTORY = new IBehaviorFactory(){

        public IBehavior createBehavior() {
            return new NiceBehavior();
        }
    };
    protected static final IBehaviorFactory ORDERED_BEHAVIOR_FACTORY = new IBehaviorFactory(){

        public IBehavior createBehavior() {
            return new OrderedBehavior();
        }
    };
    protected static final IBehaviorFactory UNORDERED_BEHAVIOR_FACTORY = new IBehaviorFactory(){

        public IBehavior createBehavior() {
            return new UnorderedBehavior();
        }
    };
    private static final JavaProxyFactory PROXY_FACTORY = new JavaProxyFactory();
    private IMockControlState state;
    private Object mock;
    private IBehavior behavior;
    private IBehaviorFactory behaviorFactory;
    public static final Range ONE = new Range(1);
    public static final Range ONE_OR_MORE = new Range(1, Integer.MAX_VALUE);
    public static final Range ZERO_OR_MORE = new Range(0, Integer.MAX_VALUE);
    public static final ParameterMatcher EQUALS_MATCHER = new AbstractMatcher(){};
    public static final ParameterMatcher ALWAYS_MATCHER = new AbstractMatcher(){

        public boolean matches(Object[] expected, Object[] actual) {
            return true;
        }

        protected String parameterToString(Object parameter) {
            return "<any>";
        }
    };
    public static final ParameterMatcher ARRAY_MATCHER = new AbstractMatcher(){

        public String parameterToString(Object parameter) {
            if (parameter instanceof boolean[]) {
                boolean[] array = (boolean[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof byte[]) {
                byte[] array = (byte[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof char[]) {
                char[] array = (char[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof double[]) {
                double[] array = (double[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof float[]) {
                float[] array = (float[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof int[]) {
                int[] array = (int[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof long[]) {
                long[] array = (long[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof short[]) {
                short[] array = (short[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + array[i];
                    ++i;
                }
                return this.inBrackets(result);
            }
            if (parameter instanceof Object[]) {
                Object[] array = (Object[])parameter;
                String result = "";
                int i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + super.parameterToString(array[i]);
                    ++i;
                }
                return this.inBrackets(result);
            }
            return super.parameterToString(parameter);
        }

        private String inBrackets(String result) {
            return "[" + result + "]";
        }

        public boolean parameterMatches(Object expected, Object actual) {
            if (expected instanceof boolean[]) {
                return Arrays.equals((boolean[])expected, (boolean[])actual);
            }
            if (expected instanceof byte[]) {
                return Arrays.equals((byte[])expected, (byte[])actual);
            }
            if (expected instanceof char[]) {
                return Arrays.equals((char[])expected, (char[])actual);
            }
            if (expected instanceof double[]) {
                return Arrays.equals((double[])expected, (double[])actual);
            }
            if (expected instanceof float[]) {
                return Arrays.equals((float[])expected, (float[])actual);
            }
            if (expected instanceof int[]) {
                return Arrays.equals((int[])expected, (int[])actual);
            }
            if (expected instanceof long[]) {
                return Arrays.equals((long[])expected, (long[])actual);
            }
            if (expected instanceof short[]) {
                return Arrays.equals((short[])expected, (short[])actual);
            }
            if (expected instanceof Object[]) {
                return Arrays.equals((Object[])expected, (Object[])actual);
            }
            return super.parameterMatches(expected, actual);
        }
    };

    public static MockControl createControl(Class interfaceToMock) {
        return new MockControl(interfaceToMock, PROXY_FACTORY, UNORDERED_BEHAVIOR_FACTORY);
    }

    public static MockControl createStrictControl(Class interfaceToMock) {
        return new MockControl(interfaceToMock, PROXY_FACTORY, ORDERED_BEHAVIOR_FACTORY);
    }

    public static MockControl createNiceControl(Class interfaceToMock) {
        MockControl control = new MockControl(interfaceToMock, PROXY_FACTORY, NICE_BEHAVIOR_FACTORY);
        return control;
    }

    protected MockControl(Class toMock, IProxyFactory proxyFactory, IBehaviorFactory behaviorFactory) {
        this.mock = proxyFactory.createProxy(toMock, new ObjectMethodsFilter(new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return MockControl.this.state.invoke(proxy, method, args);
                }
                catch (Throwable e) {
                    throw e.fillInStackTrace();
                }
            }
        }));
        this.behaviorFactory = behaviorFactory;
        this.reset();
    }

    public Object getMock() {
        return this.mock;
    }

    public final void reset() {
        this.behavior = this.behaviorFactory.createBehavior();
        this.state = new RecordState(this.behavior);
    }

    public void activate() {
        this.replay();
    }

    public void replay() {
        try {
            this.state.replay();
            this.state = new PlayState(this.behavior);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void verify() {
        try {
            this.state.verify();
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setVoidCallable() {
        try {
            this.state.setVoidCallable(ONE);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable) {
        try {
            this.state.setThrowable(throwable, ONE);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setReturnValue(long value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(float value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(double value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(Object value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (IllegalStateException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setVoidCallable(int times) {
        try {
            this.state.setVoidCallable(new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, int times) {
        try {
            this.state.setThrowable(throwable, new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(double value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(float value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(long value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(Object value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setVoidCallable(Range range) {
        try {
            this.state.setVoidCallable(range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, Range range) {
        try {
            this.state.setThrowable(throwable, range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(double value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(float value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(long value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(Object object, Range range) {
        try {
            this.state.setReturnValue(object, range);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultVoidCallable() {
        try {
            this.state.setDefaultVoidCallable();
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultThrowable(Throwable throwable) {
        try {
            this.state.setDefaultThrowable(throwable);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(boolean value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(long value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(float value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(double value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(Object value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setMatcher(ParameterMatcher matcher) {
        try {
            this.state.setMatcher(matcher);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setVoidCallable(int minCount, int maxCount) {
        try {
            this.state.setVoidCallable(new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, int minCount, int maxCount) {
        try {
            this.state.setThrowable(throwable, new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(long value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(float value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(double value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setReturnValue(Object value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void setDefaultMatcher(ParameterMatcher matcher) {
        try {
            this.state.setDefaultMatcher(matcher);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)e.fillInStackTrace();
        }
    }

    public void expectAndReturn(boolean ignored, boolean value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(long ignored, long value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(float ignored, float value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(double ignored, double value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(Object ignored, Object value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(boolean ignored, boolean value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(long ignored, long value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(float ignored, float value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(double ignored, double value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(Object ignored, Object value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(boolean ignored, boolean value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(long ignored, long value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(float ignored, float value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(double ignored, double value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(Object ignored, Object value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(boolean ignored, boolean value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(long ignored, long value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(float ignored, float value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(double ignored, double value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(Object ignored, Object value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(long ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(float ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(double ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(Object ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(long ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(float ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(double ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(Object ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(long ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(float ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(double ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(Object ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(long ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(float ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(double ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(Object ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }
}

