/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.sql;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationSet;
import com.mockobjects.MapEntry;
import com.mockobjects.ReturnObjectList;
import com.mockobjects.sql.CommonMockStatement;
import com.mockobjects.sql.MockResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class CommonMockPreparedStatement
extends CommonMockStatement
implements PreparedStatement {
    private ExpectationSet mySetParameters = new ExpectationSet("CommonMockPreparedStatement.setParameters");
    private ExpectationCounter myClearParametersCalls = new ExpectationCounter("CommonMockPreparedStatement.clearParameters() calls");
    private ExpectationSet myTargetSQLTypes = new ExpectationSet("CommonMockPreparedStatement.targetSQLTypes");
    private final ReturnObjectList myResultSets = new ReturnObjectList("result sets");
    private final ReturnObjectList executeUpdates = new ReturnObjectList("update count");

    CommonMockPreparedStatement() {
    }

    public void addResultSet(MockResultSet aResultSet) {
        this.myResultSets.addObjectToReturn((Object)aResultSet);
    }

    public void addExpectedSetParameter(int parameterIndex, int intValue) {
        this.addExpectedSetParameter(parameterIndex, new Integer(intValue));
    }

    public void addExpectedSetParameter(int parameterIndex, Object parameterValue) {
        this.mySetParameters.addExpected((Object)new MapEntry((Object)new Integer(parameterIndex), parameterValue));
    }

    public void addExpectedSetParameters(Object[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            this.addExpectedSetParameter(i + 1, parameters[i]);
            ++i;
        }
    }

    public void addExpectedTargetSQLType(int aTargetSQLType) {
        this.myTargetSQLTypes.addExpected((Object)new Integer(aTargetSQLType));
    }

    public void setExpectedClearParametersCalls(int callCount) {
        this.myClearParametersCalls.setExpected(callCount);
    }

    public void setExpectingNoSetParameters() {
        this.mySetParameters.setExpectNothing();
    }

    public void clearParameters() throws SQLException {
        this.myClearParametersCalls.inc();
    }

    public boolean execute() throws SQLException {
        this.innerExecute();
        return false;
    }

    public ResultSet executeQuery() throws SQLException {
        this.innerExecute();
        return (ResultSet)this.myResultSets.nextReturnObject();
    }

    public void addUpdateCount(int count) {
        this.executeUpdates.addObjectToReturn(count);
    }

    public int executeUpdate() throws SQLException {
        this.innerExecute();
        return (Integer)this.executeUpdates.nextReturnObject();
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, new Integer(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setTimestamp(int param, Timestamp timestamp) throws SQLException {
        this.setObject(param, timestamp);
    }

    public void setClob(int param, Clob clob) throws SQLException {
        this.setObject(param, clob);
    }

    public void setLong(int param, long aLong) throws SQLException {
        this.setObject(param, new Long(aLong));
    }

    public void setNull(int param, int param1) throws SQLException {
        this.setObject(param, null);
    }

    public void setArray(int param, Array array) throws SQLException {
        this.setObject(param, array);
    }

    public void setShort(int param, short aShort) throws SQLException {
        this.setObject(param, new Short(aShort));
    }

    public void setTime(int param, Time time, Calendar calendar) throws SQLException {
        this.setObject(param, time);
    }

    public void setObject(int param, Object anObject, int aTargetSQLType) throws SQLException {
        this.setObject(param, anObject);
        this.myTargetSQLTypes.addActual((Object)new Integer(aTargetSQLType));
    }

    public void setRef(int param, Ref ref) throws SQLException {
        this.setObject(param, ref);
    }

    public void setDate(int param, Date date) throws SQLException {
        this.setObject(param, date);
    }

    public void setFloat(int param, float aFloat) throws SQLException {
        this.setObject(param, new Float(aFloat));
    }

    public void setBlob(int param, Blob blob) throws SQLException {
        this.setObject(param, blob);
    }

    public void setDate(int param, Date date, Calendar calendar) throws SQLException {
        this.setDate(param, date);
    }

    public void setBytes(int param, byte[] values) throws SQLException {
        this.setObject(param, values);
    }

    public void setObject(int param, Object anObject) throws SQLException {
        this.mySetParameters.addActual((Object)new MapEntry((Object)new Integer(param), anObject));
    }

    public void setByte(int param, byte aByte) throws SQLException {
        this.setObject(param, new Byte(aByte));
    }

    public void setDouble(int param, double aDouble) throws SQLException {
        this.setObject(param, new Double(aDouble));
    }

    public void setTime(int param, Time time) throws SQLException {
        this.setObject(param, time);
    }

    public void setBoolean(int param, boolean aBoolean) throws SQLException {
        this.setObject(param, new Boolean(aBoolean));
    }

    public void setBigDecimal(int param, BigDecimal bigDecimal) throws SQLException {
        this.setObject(param, bigDecimal);
    }

    public void addBatch() throws SQLException {
        this.notImplemented();
    }

    public void setObject(int param, Object anObject, int targetSqlType, int scale) throws SQLException {
        this.notImplemented();
    }

    public void setCharacterStream(int param, Reader reader, int length) throws SQLException {
        this.notImplemented();
    }

    public void setAsciiStream(int param, InputStream inputStream, int length) throws SQLException {
        this.notImplemented();
    }

    public void setBinaryStream(int param, InputStream inputStream, int length) throws SQLException {
        this.notImplemented();
    }

    public void setNull(int param, int param1, String typeName) throws SQLException {
        this.notImplemented();
    }

    public void setUnicodeStream(int param, InputStream inputStream, int length) throws SQLException {
        this.notImplemented();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.notImplemented();
        return null;
    }

    public void setTimestamp(int param, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.notImplemented();
    }
}

