/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.sql;

import com.mockobjects.sql.MockResultSet;
import java.sql.SQLException;
import junit.framework.Assert;

abstract class CommonMockMultiRowResultSet
extends MockResultSet {
    private Object[][] myRows = new Object[0][0];
    private String[] myColumnNames;
    private int myRowOffset = -1;
    private SQLException myGetException = null;

    public CommonMockMultiRowResultSet() {
    }

    public CommonMockMultiRowResultSet(String name) {
        super(name);
    }

    public void setupColumnNames(String[] columnNames) {
        this.myColumnNames = columnNames;
    }

    public void setupRows(Object[][] rows) {
        this.myRows = rows;
    }

    public void setupThrowExceptionOnGet(SQLException exception) {
        this.myGetException = exception;
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.throwGetExceptionIfAny();
        if (columnIndex > this.myRows[this.myRowOffset].length || columnIndex < 1) {
            Assert.fail((String)("Column " + columnIndex + " not found in " + this.name));
        }
        return this.myRows[this.myRowOffset][columnIndex - 1];
    }

    public Object getObject(String columnName) throws SQLException {
        this.throwGetExceptionIfAny();
        return this.getObject(this.findIndexForColumnName(columnName));
    }

    public boolean next() throws SQLException {
        this.myNextCalls.inc();
        if (this.myRowOffset + 1 >= this.myRows.length) {
            return false;
        }
        ++this.myRowOffset;
        return true;
    }

    public int getRow() throws SQLException {
        return this.myRowOffset + 1;
    }

    private void throwGetExceptionIfAny() throws SQLException {
        if (null != this.myGetException) {
            throw this.myGetException;
        }
    }

    private int findIndexForColumnName(String columnName) throws SQLException {
        int i = 0;
        while (i < this.myColumnNames.length) {
            if (this.myColumnNames[i].equalsIgnoreCase(columnName)) {
                return i + 1;
            }
            ++i;
        }
        throw new SQLException("Column name not found");
    }
}

