package jp.sourceforge.masme.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.service.EditTargetService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;

public class EditOkAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        DynaValidatorForm dynaForm = (DynaValidatorForm) form;
        MaintenanceWorkTarget target = (MaintenanceWorkTarget) request
                .getSession().getAttribute("maintenanceTarget");
        List<String> propertyNames = (List<String>) dynaForm
                .get("propertyNames");
        List<Object> propertyValuesStr = (List<Object>) dynaForm
                .get("propertyValues");

        try {
            service.edit(target, propertyNames, propertyValuesStr);
        } catch (MasmenValidateException ex) {
            // バリデーション処理失敗時にエラーメッセージを表示する
            ActionMessages ms = new ActionMessages();
            ActionMessage m = new ActionMessage(ex.getMessage(), false);
            ms.add(ActionMessages.GLOBAL_MESSAGE, m);
            saveErrors(request, ms);
            return mapping.findForward("retry");
        }

        return mapping.findForward("success");
    }

    /** このアクションで利用するサービス */
    private EditTargetService service;

    /**
     * @param service
     *            このアクションで利用するサービス
     */
    public void setService(EditTargetService service) {
        this.service = service;
    }
}
