package jp.sourceforge.masme.validation.drools;

import java.util.Map;

import jp.sourceforge.masme.meta.MetaClass;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.validation.ValidateFunctionFactory;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;

/**
 * 
 * Droolsの実行を行う{@code ValidateFunctionFactory}の実装クラス
 */
public class DroolsValidateFunctionFactory implements ValidateFunctionFactory {

    private Map<String, String> drlResourceMap;

    public void setDrlResourceMap(Map<String, String> drlResourceMap) {
        this.drlResourceMap = drlResourceMap;
    }

    /**
     * @see jp.sourceforge.masme.validation.ValidateFunctionFactory#createValidateFunction(jp.sourceforge.masme.meta.ReferenceMetaProperty)
     */
    public DroolsValidateFunction createValidateFunction(
            ReferenceMetaProperty referenceMetaProperty) {
        return createValidateFunction(referenceMetaProperty
                .getValidationMethodName());
    }

    /**
     * @see jp.sourceforge.masme.validation.ValidateFunctionFactory#createValidateFunction(jp.sourceforge.masme.meta.MetaClass)
     */
    public DroolsValidateFunction createValidateFunction(MetaClass metaClass) {
        return createValidateFunction(metaClass
                .getValidationMethodName());
    }
    /**
     * 
     * @param ruleResourcePath
     * @return
     */
    private DroolsValidateFunction createValidateFunction(String ruleResourcePath) {
        // knowledge base の作成
        String drlResourcePath = drlResourceMap.get(ruleResourcePath);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory
                .newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource(drlResourcePath,
                getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new IllegalArgumentException("rule file (" + drlResourcePath
                    + ") has error." + kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());

        // 
        DroolsValidateFunction validateFunction = new DroolsValidateFunction();

        validateFunction.setKnowledgeBase(kbase);

        return validateFunction;
    }
}
