package jp.sourceforge.masme.validation.impl;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masme.MasmenMockTestSupport;
import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.entity.ReflectState;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.meta.AnnotationMetaInfoFactoryBean;
import jp.sourceforge.masme.meta.MasmenMetaInfo;
import jp.sourceforge.masme.target.impl.MaintenanceTargetFactoryImpl;
import jp.sourceforge.masme.target.impl.MaintenanceWorkTargetImpl;
import jp.sourceforge.masme.test.entity.Company;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.Customer;
import jp.sourceforge.masme.test.entity.CustomerWork;

public class MasmenValidationImplNullableCompanyTest
        extends
            MasmenMockTestSupport {
    MasmenValidationImpl validation;

    MasmenMetaInfo metaInfo;

    @Override
    public void setUp() throws Exception {
        validation = new MasmenValidationImpl();

        // create meta info
        AnnotationMetaInfoFactoryBean factoryBean = new AnnotationMetaInfoFactoryBean();
        List<String> clsList = new ArrayList<String>();
        clsList.add(Customer.class.getName());
        clsList.add(Company.class.getName());
        factoryBean.setAnnotatedMaintenanceClassNames(clsList);
        MethodValidateFunctionFactory validateFunctionFactory = new MethodValidateFunctionFactory();
        factoryBean.setValidateFunctionFactory(validateFunctionFactory);
        factoryBean.afterPropertiesSet();
        metaInfo = (MasmenMetaInfo) factoryBean.getObject();

    }

    public void test_edit_customer_without_company() {
        CustomerWork customerWork = createCustomerWork();
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.edit(target);
    }

    public void test_edit_customer_with_company() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.edit(target);
    }

    public void test_edit_customer_with_underqualified_company() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        companyWork.setName("test");
        customerWork.setName("test");
        customerWork.setNullableCompanyWork(companyWork);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        try {
            validation.edit(target);
            fail();
        } catch (MasmenValidateException e) {

        }
    }

    public void test_confirm_customer_ok_real_ok_work() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        Company company = createCompany();
        companyWork.setRealEntity(company);
        customerWork.setNullableCompanyWork(companyWork);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);

    }

    public void test_confirm_customer_ng_real_ok_work_status_ok() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        companyWork.getCustomerWorks().add(customerWork);
        Company company = createCompany();
        customerWork.setNullableCompany(company);
        companyWork.setRealEntity(company);
        customerWork.setName("ng");
        company.setName("ng");
        companyWork.setName("ok");
        // 反映待ちかつ日付もok
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        customerWork.getWorkInfo().setScheduledDate(AFTER_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }

    public void test_confirm_customer_no_real_ok_work_status_ok() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        companyWork.getCustomerWorks().add(customerWork);
        // 反映待ちかつ日付もok
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        customerWork.getWorkInfo().setScheduledDate(AFTER_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);

    }

    public void test_confirm_customer_ng_real_ok_work_status_ng() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        companyWork.getCustomerWorks().add(customerWork);
        Company company = createCompany();
        customerWork.setNullableCompany(company);
        companyWork.setRealEntity(company);
        customerWork.setName("ng");
        company.setName("ng");
        companyWork.setName("ok");
        // 修正中でNG
        companyWork.getWorkInfo().setReflectState(ReflectState.EDITED);
        companyWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        customerWork.getWorkInfo().setScheduledDate(AFTER_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        try {
            validation.confirm(target);
            fail();
        } catch (MasmenValidateException e) {

        }
    }
    public void test_confirm_customer_no_real_ok_work_status_ng() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        companyWork.getCustomerWorks().add(customerWork);
        // 修正中でNG
        companyWork.getWorkInfo().setReflectState(ReflectState.EDITED);
        companyWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        customerWork.getWorkInfo().setScheduledDate(AFTER_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }

    public void test_confirm_customer_ng_real_ok_work_date_ng() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        Company company = createCompany();
        customerWork.setNullableCompany(company);
        companyWork.setRealEntity(company);
        customerWork.setName("ng");
        company.setName("ng");
        companyWork.setName("ok");
        // 反映順不正
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.getWorkInfo().setScheduledDate(AFTER_DATE);
        customerWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        try {
            validation.confirm(target);
            fail();
        } catch (MasmenValidateException e) {
        }
    }
    public void test_confirm_customer_no_real_ok_work_date_ng() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        // 反映順不正
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.getWorkInfo().setScheduledDate(AFTER_DATE);
        customerWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }

    public void test_confirm_customer_ng_real_ok_work_date_equal() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        Company company = createCompany();
        customerWork.setNullableCompany(company);
        companyWork.setRealEntity(company);
        customerWork.setName("ng");
        company.setName("ng");
        companyWork.setName("ok");
        // 反映日が同日でok
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        customerWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }
    public void test_confirm_customer_no_real_ok_work_date_equal() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        customerWork.setNullableCompanyWork(companyWork);
        // 反映日が同日でok
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        customerWork.getWorkInfo().setScheduledDate(BEFORE_DATE);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }

    public void test_confirm_customer_ok_real_ng_work_date_equal() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        Company company = createCompany();
        companyWork.setRealEntity(company);
        // 反映待ち
        companyWork.getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
        companyWork.setName("test");
        customerWork.setName("test");
        customerWork.setNullableCompanyWork(companyWork);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        try {
            validation.confirm(target);
            fail();
        } catch (MasmenValidateException e) {
        }
    }

    public void test_confirm_customer_ng_real_ng_work_date_equal() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        Company company = createCompany();
        companyWork.setRealEntity(company);
        companyWork.setName("test");
        customerWork.setName("test");
        company.setName("test");
        customerWork.setNullableCompanyWork(companyWork);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        try {
            validation.confirm(target);
            fail();
        } catch (MasmenValidateException e) {
        }
    }
    public void test_confirm_customer_no_real_ng_work_date_equal() {
        CustomerWork customerWork = createCustomerWork();
        CompanyWork companyWork = createCompanyWork();
        companyWork.setName("test");
        customerWork.setName("test");
        customerWork.setNullableCompanyWork(companyWork);
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }
    public void test_confirm_customer_no_real_no_work() {
        CustomerWork customerWork = createCustomerWork();
        MaintenanceWorkTargetImpl target = createTarget(customerWork);
        validation.confirm(target);
    }

    private MaintenanceWorkTargetImpl createTarget(WorkEntity entity) {
        MaintenanceWorkTargetImpl target = new MaintenanceWorkTargetImpl(entity
                .getClass(), entity);
        target.setMasmenMetaInfo(metaInfo);
        MaintenanceTargetFactoryImpl factory = new MaintenanceTargetFactoryImpl();
        factory.setMasmenMetaInfo(metaInfo);
        factory.setMaintenanceTargetFactory(factory);
        target.setMaintenanceTargetFactory(factory);
        target.init();
        return target;
    }
    public static CustomerWork createCustomerWork() {
        CustomerWork entity = createCustomerWork("1");
        entity.setCompanyWork(createCompanyWork());
        entity.setCompany(createCompany());
        entity.getCompanyWork().setRealEntity(entity.getCompany());
        return entity;
    }

}
