package jp.sourceforge.masme.validation;

import java.util.Date;

import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.entity.ReflectState;
import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;

/**
 * 失敗したことを示すバリデーションの実行結果を保持したオブジェクト
 */
public class ValidationResultFailure implements ValidationResult {
    Exception exception;
    String errorMessage;
    /** メンテナンス対象のエンティティ */
    WorkInfo maintenanceTarget;
    /** メンテナンス対象に関連するエンティティ */
    WorkInfo anotherTarget;

    /**
     * 
     * @param errorMessage
     * @param target
     *            メンテナンス対象のエンティティ
     * @param referenceTarget
     *            メンテナンス対象に関連するエンティティ
     */
    public ValidationResultFailure(String errorMessage,
            MaintenanceEntity maintenanceTarget, MaintenanceEntity anotherTarget) {
        this.errorMessage = errorMessage;
        this.maintenanceTarget = MasmenEntityUtils
                .getWorkInfo(maintenanceTarget);
        this.anotherTarget = MasmenEntityUtils.getWorkInfo(anotherTarget);
    }

    /**
     * 
     * @param e
     * @param target
     *            メンテナンス対象のエンティティ
     * @param referenceTarget
     *            メンテナンス対象に関連するエンティティ
     */
    public ValidationResultFailure(Exception e,
            MaintenanceEntity maintenanceTarget, MaintenanceEntity anotherTarget) {
        this.exception = e;
        this.errorMessage = e.getMessage();
        this.maintenanceTarget = MasmenEntityUtils
                .getWorkInfo(maintenanceTarget);
        this.anotherTarget = MasmenEntityUtils.getWorkInfo(anotherTarget);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getClass().getSimpleName() + "[" + this.errorMessage + "]");
        sb.append("[target:" + maintenanceTarget + ",another:" + anotherTarget
                + "]");

        return sb.toString();
    }

    public boolean validationSuccess() {
        return false;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public boolean validateNotWaitReflect() {
        if (anotherTarget != null) {
            boolean result = anotherTarget.getReflectState() != ReflectState.WAIT_REFLECT;
            return result;
        }
        return false;
    }

    /**
     * 最初に反映されるかどうかの検証をします。
     */
    public boolean validateReflectFirst() {
        if (anotherTarget == null) {
            //TODO ワークは論理削除になるため、このケースはありえないはず
            return true;
        }
        if (anotherTarget.getReflectState() == ReflectState.WAIT_REFLECT) {
            Date thisDate = maintenanceTarget.getScheduledDate();
            Date anotherDate = anotherTarget.getScheduledDate();
            if (thisDate != null && anotherDate != null
                    && anotherDate.getTime() <= thisDate.getTime()) {
                return true;
            }
        }
        return false;
    }

    public Exception getException() {
        return exception;
    }
}
