package jp.sourceforge.masme.validation;

import jp.sourceforge.masme.meta.MetaClass;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;


/**
 * {@code ValidateFunction}を作成するインタフェースです
 */
public interface ValidateFunctionFactory {
    
    /**
     * 
     * {@code ValidateFunction}を作成します
     * @param referenceMetaProperty 参照メタプロパティ
     * @return {@code ValidateFunction}の実装オブジェクト
     * 
     */
    ValidateFunction createValidateFunction(ReferenceMetaProperty referenceMetaProperty);
    /**
     * {@code ValidateFunction}を作成します
     * @param referenceMetaProperty 参照メタプロパティ
     * @param metaClass メタクラス
     * @return {@code ValidateFunction}の実装オブジェクト
     */
    ValidateFunction createValidateFunction(MetaClass metaClass);
}
