package jp.sourceforge.masme.validation;

import jp.sourceforge.masme.target.MaintenanceWorkTarget;

/**
 * マスタメンテナンスシステムにおいて、整合性を保障するオブジェクト
 */
public interface MasmenValidation {
    /**
     * 修正時に行う整合性チェック
     * <p>
     * ワーク情報における整合性が保障されている状態でなければならない
     */
    void edit(MaintenanceWorkTarget target);

    /***
     * 修正キャンセル時に行う整合性チェック
     * <p>
     * ワーク情報における整合性が保障されている状態でなければならない
     */
    void cancelEdit(MaintenanceWorkTarget target);

    /**
     * 確認時に行う整合性チェック
     * <p>
     * 反映順番などによる、本番反映時の整合性を保障しなければならない
     */
    void confirm(MaintenanceWorkTarget target);

    /**
     * 確認キャンセル時に行う整合性チェック
     * <p>
     * 反映順番などによる、本番反映時の整合性を保障しなければならない
     */
    void cancelConfirm(MaintenanceWorkTarget target);
}
