package jp.sourceforge.masme.target.impl;

import java.util.ArrayList;
import java.util.Collection;

import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;
import jp.sourceforge.masme.target.ValidateProperty;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;
import jp.sourceforge.masme.validation.MultipleValidationResult;
import jp.sourceforge.masme.validation.ValidateFunction;
import jp.sourceforge.masme.validation.ValidationResult;
import jp.sourceforge.masme.validation.ValidationResultFailure;
import jp.sourceforge.masme.validation.ValidationResultSuccess;

public class ValidatePropertyImpl extends MaintenanceSupport implements
        ValidateProperty {

    private MaintenanceTarget maintenanceTarget;

    private ReferenceMetaProperty rMetaProperty;
    
    public ValidatePropertyImpl(MaintenanceTarget target, ReferenceMetaProperty metaProperty) {
        this.maintenanceTarget = target;
        rMetaProperty = metaProperty;
    }

    /**
     * @see jp.sourceforge.masmen.target.ValidateProperty#invokeWorkValidateMethod(MaintenanceWorkTarget))
     */
    public ValidationResult invokeWorkValidateMethod(
            MaintenanceWorkTarget entity) {
        return invokeValidateMethod(entity.getEntity(),
                getWorkTargetCollection(), entity);
    }

    /**
     * @see jp.sourceforge.masme.target.ValidateProperty#invokeRealValidateMethod(MaintenanceWorkTarget)
     */
    public ValidationResult invokeRealValidateMethod(
            MaintenanceWorkTarget entity) {
        return invokeValidateMethod(entity.getEntity().getRealEntity(),
                getWorkTargetCollection(), entity);
    }

    protected ValidationResult invokeValidateMethod(
            MaintenanceEntity targetEntity,
            Collection<WorkEntity> referencedWorkEntities,
            MaintenanceWorkTarget entity) {
        // 全ての関連オブジェクトに対しての結果を格納する
        MultipleValidationResult results = new MultipleValidationResult();
        for (WorkEntity referencedEntity : referencedWorkEntities) {
            // 削除時には、失敗とする
            if (entity.getWorkInfo().getDeleteFlag()) {
                if (referencedEntity.getWorkInfo().getDeleteFlag()) {
                    results.getResults().add(new ValidationResultSuccess());
                } else {
                    results.getResults().add(
                            new ValidationResultFailure("削除すること", entity
                                    .getEntity(), referencedEntity));
                }
                continue;
            }
            try {
                ValidateFunction validateFunction = rMetaProperty.getValidateFunction();
                validateFunction.invoke(referencedEntity, targetEntity);
                results.getResults().add(new ValidationResultSuccess());
            } catch (RuntimeException e) {
                results.getResults().add(
                        new ValidationResultFailure(e, entity.getEntity(),
                                referencedEntity));
            }
        }
        return results;
    }

    public boolean isNonDeletedProperty() {
        for (WorkEntity work : getWorkTargetCollection()) {
            if (!work.getWorkInfo().getDeleteFlag()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getClass().getSimpleName());
        sb.append(":");
        String propertyName = (rMetaProperty == null) ? null : rMetaProperty
                .getPropertyName();
        sb.append("ReferenceMetaProperty=" + propertyName);
        sb.append("ReferenceMetaProperty=" + this.getRMetaProperty());
        return sb.toString();
    }

    /**
     * @param maintenanceTarget
     *            maintenanceTarget を設定。
     */
    public void setMaintenanceTarget(AbstractMaintenanceTarget maintenanceTarget) {
        this.maintenanceTarget = maintenanceTarget;
    }

    /**
     * @return rMetaProperty を戻します。
     */
    public ReferenceMetaProperty getRMetaProperty() {
        return rMetaProperty;
    }

    /**
     * @param metaProperty
     *            rMetaProperty を設定。
     */
    public void setRMetaProperty(ReferenceMetaProperty metaProperty) {
        rMetaProperty = metaProperty;
    }

    /**
     * @return 対応するワークエンティティの集合 を戻します。
     */
    protected Collection<WorkEntity> getWorkTargetCollection() {
        Object propertyValue = MasmenEntityUtils.getProperty(maintenanceTarget
                .getEntity(), rMetaProperty.getWorkReferencedPropertyName());
        Collection<WorkEntity> targetCollection = (Collection<WorkEntity>) propertyValue;
        if (targetCollection == null) {
            targetCollection = new ArrayList<WorkEntity>();
        }
        return targetCollection;
    }

}