package jp.sourceforge.masme.target.impl;

import java.io.Serializable;

import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.meta.MetaProperty;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.target.MaintenanceRealTarget;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;
import jp.sourceforge.masme.target.ReferenceProperty;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;
import jp.sourceforge.masme.validation.ValidateFunction;
import jp.sourceforge.masme.validation.ValidationResult;
import jp.sourceforge.masme.validation.ValidationResultFailure;
import jp.sourceforge.masme.validation.ValidationResultSuccess;

public class ReferencePropertyImpl extends MaintenancePropertyImpl implements
        ReferenceProperty {

    /**
     * @param target
     * @param metaProperty
     */
    public ReferencePropertyImpl(MaintenanceTarget target,
            MetaProperty metaProperty) {
        super(target, metaProperty);

    }

    public ReferenceMetaProperty getMetaProperty() {
        return (ReferenceMetaProperty) super.getMetaProperty();
    }

    /**
     * 参照情報を使い、ワークプロパティに対して値を設定する
     */
    @Override
    public void setPropertyValue(Object value) {
        MaintenanceEntity entity = maintenanceTarget.getEntity();
        WorkEntity work = getReferenceWorkValueFromDb((Serializable) value);
        MasmenEntityUtils.setProperty(entity, getMetaProperty()
                .getWorkPropertyName(), work);
    }

    /**
     * 参照情報を使い、ワークプロパティの主キーを返すように修正
     */
    @Override
    public Serializable getPropertyValue() {
        MaintenanceWorkTarget workTarget = getReferenceWorkTarget();
        return (workTarget != null) ? workTarget.getId() : null;
    }

    protected WorkEntity getReferenceWorkValueFromDb(Serializable key) {
        if (key == null) {
            return null;
        }
        WorkEntity entity = (WorkEntity) dao.get(getMetaProperty()
                .getReferenceMetaClass().getWorkClass(), key);
        if (entity != null && entity.getWorkInfo().getDeleteFlag()) {
            return null;
        }
        return entity;
    }

    /**
     * @see jp.sourceforge.masme.target.ReferenceProperty#getReferenceWorkTarget()
     */
    public MaintenanceWorkTarget getReferenceWorkTarget() {
        String workPropertyName = getMetaProperty().getWorkPropertyName();
        Object workValue = MasmenEntityUtils.getProperty(maintenanceTarget
                .getEntity(), workPropertyName);
        if (workValue == null) {
            return null;
        }

        MaintenanceWorkTarget referenceWorkProperty = (MaintenanceWorkTarget) factory
                .createMaintenanceTargetEntity(getMetaProperty()
                        .getReferenceMetaClass().getWorkClass(),
                        (WorkEntity) workValue);
        return referenceWorkProperty;
    }

    /**
     * @see jp.sourceforge.masme.target.ReferenceProperty#getReferenceRealTarget()
     */
    public MaintenanceRealTarget getReferenceRealTarget() {
        MaintenanceWorkTarget maintenanceWorkTarget = getReferenceWorkTarget();
        if (maintenanceWorkTarget == null) {
            return null;
        }
        return maintenanceWorkTarget.getRealTarget();
    }

    /**
     * @see jp.sourceforge.masme.target.ReferenceProperty#invokeWorkValidateMethod()
     */
    public ValidationResult invokeWorkValidateMethod() {
        return invokeValidateMethod(getReferenceWorkTarget());
    }

    /**
     * @see jp.sourceforge.masme.target.ReferenceProperty#invokeRealValidateMethod()
     */
    public ValidationResult invokeRealValidateMethod() {
        return invokeValidateMethod(getReferenceRealTarget());
    }

    /**
     * クラスが表すオブジェクトと引数で渡されたオブジェクトに対して
     * バリデーションメソッドの実行を行います。
     * @param target
     */
    protected ValidationResult invokeValidateMethod(MaintenanceTarget target) {
        ValidateFunction validateFunction = getMetaProperty().getValidateFunction();
        MaintenanceEntity targetObject = super.maintenanceTarget.getEntity();
        MaintenanceEntity parameter;
        if (target != null && target.getEntity() != null) {
            parameter = target.getEntity();
        } else {
            parameter = null;
        }
        try {
            validateFunction.invoke(targetObject, parameter);
        } catch (RuntimeException e) {
            MaintenanceEntity parameterWork;
            if (getReferenceWorkTarget() != null) {
                parameterWork = getReferenceWorkTarget().getEntity();
            } else {
                parameterWork = null;
            }
            return new ValidationResultFailure(e, targetObject, parameterWork);
        }
        return new ValidationResultSuccess();

    }

}