package jp.sourceforge.masme.target.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.entity.RealEntity;
import jp.sourceforge.masme.entity.ReflectState;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.target.MaintenanceProperty;
import jp.sourceforge.masme.target.MaintenanceRealTarget;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;

public class MaintenanceWorkTargetImpl extends AbstractMaintenanceTarget
        implements MaintenanceWorkTarget {

    /**
     * @param entity
     */
    public MaintenanceWorkTargetImpl(Class clazz, WorkEntity entity) {
        super(clazz, entity);
    }

    public void add(Serializable id, List<String> propertyNames,
            List<Object> propertyValues) {
        setId(id);
        MaintenanceEntity entity = dao.get(this.getMaintenanceMetaClass()
                .getWorkClass(), this.getId());
        if (entity != null) {
            throw new MasmenValidateException("キー重複エラー"
                    + this.getMaintenanceMetaClass().getWorkClass() + "("
                    + this.getId() + ")");
        }
        writeProperty(propertyNames, propertyValues);
        add();
    }
    public void add() {
        getEntity().setWorkInfo(new WorkInfo());
        validation.edit(this);
        dao.save(this.getEntity());
        getEntity().getWorkInfo().setDeleteFlag(false);
        getEntity().getWorkInfo().setReflectState(ReflectState.EDITED);
    }

    public void edit(List<String> propertyNames, List<Object> propertyValues) {
        if (this.getWorkInfo().getReflectState() == ReflectState.WAIT_REFLECT) {
            throw new MasmenValidateException("反映待ちのため修正できません"
                    + this.getMaintenanceMetaClass().getWorkClass() + "("
                    + this.getId() + ")");
        }
        
        dao.update(this.getEntity());
        writeProperty(propertyNames, propertyValues);
        edit();
    }
    public void edit(){
        validation.edit(this);
        getEntity().getWorkInfo().setDeleteFlag(false);
        getEntity().getWorkInfo().setReflectState(ReflectState.EDITED);
        
    }

    private void writeProperty(List<String> propertyNames,
            List<Object> propertyValues) {
        for (int i = 0; i < propertyNames.size(); i++) {
            for (MaintenanceProperty mp : getMaintenanceProperties()) {
                if (mp.getPropertyName().equals(propertyNames.get(i))) {
                    mp.setPropertyValue(propertyValues.get(i));
                    break;
                }
            }
        }
    }

    public boolean delete() {
        if (this.getWorkInfo().getReflectState() == ReflectState.WAIT_REFLECT) {
            throw new MasmenValidateException("反映待ちのため修正できません"
                    + this.getMaintenanceMetaClass().getWorkClass() + "("
                    + this.getId() + ")");
        }
        dao.update(this.getEntity());
        getEntity().getWorkInfo().setDeleteFlag(true);
        getEntity().getWorkInfo().setReflectState(ReflectState.EDITED);
        validation.edit(this);

        // 未反映ならば削除
        if (getEntity().getRealEntity() == null) {
            dao.delete(getEntity());
            return true;
        }

        return false;
    }

    public boolean cancelEdit() {
        if (this.getWorkInfo().getReflectState() == ReflectState.WAIT_REFLECT) {
            throw new MasmenValidateException("反映待ちのため修正できません"
                    + this.getMaintenanceMetaClass().getWorkClass() + "("
                    + this.getId() + ")");
        }
        dao.update(this.getEntity());
        RealEntity realEntity = getEntity().getRealEntity();
        if (realEntity != null) {
            MasmenEntityUtils.replaceProperties(realEntity, getEntity(),
                    getMaintenanceMetaClass());
            getEntity().getWorkInfo().setDeleteFlag(false);
        } else {
            getEntity().getWorkInfo().setDeleteFlag(true);
        }
        validation.cancelEdit(this);

        // 未反映ならば削除
        if (realEntity == null) {
            dao.delete(getEntity());
            return true;
        } else {
            getWorkInfo().setReflectState(ReflectState.REFLECTED);
            getWorkInfo().setReflectedTimestamp(new Date());
            getWorkInfo().setScheduledDate(null);
        }

        return false;
    }

    public void confirm() {
        if (this.getWorkInfo().getScheduledDate() == null) {
            throw new MasmenValidateException("確認前には反映日を入力してください"
                    + this.getMaintenanceMetaClass().getWorkClass() + "("
                    + this.getId() + ")" + getWorkInfo().getScheduledDate());
        }
        dao.update(this.getEntity());
        validation.confirm(this);

        getWorkInfo().setReflectState(ReflectState.WAIT_REFLECT);
    }

    public void cancelConfirm() {
        dao.update(this.getEntity());
        validation.cancelConfirm(this);

        getWorkInfo().setReflectState(ReflectState.EDITED);
    }

    public void changeScheduleDate(Date scheduleDate) {
        getWorkInfo().setScheduledDate(scheduleDate);
        dao.update(this.getEntity());
    }

    public void reflect() {
        log.info("start reflect" + this);

        WorkEntity workEntity = this.getEntity();
        RealEntity realEntity = workEntity.getRealEntity();
        // delete
        if (workEntity.getWorkInfo().getDeleteFlag()) {
            dao.delete(realEntity);
            dao.delete(workEntity);
            return;
        }
        if (realEntity == null) { // insert
            MaintenanceTarget realTarget = factory
                    .createMaintenanceTargetEntity(getMaintenanceMetaClass()
                            .getRealClass());
            realEntity = (RealEntity) realTarget.getEntity();
            MasmenEntityUtils.setProperty(realEntity, getMaintenanceMetaClass()
                    .getIdName(), getId());
            dao.save(realEntity);
        }
        MasmenEntityUtils.replaceProperties(workEntity, realEntity, this
                .getMaintenanceMetaClass());

        getWorkInfo().setReflectState(ReflectState.REFLECTED);
        getWorkInfo().setReflectedTimestamp(new Date());
        getWorkInfo().setScheduledDate(null);

        dao.update(workEntity);
        dao.update(realEntity);

    }

    public WorkInfo getWorkInfo() {
        WorkEntity work = (WorkEntity) this.getEntity();
        return work.getWorkInfo();
    }

    public WorkEntity getEntity() {
        WorkEntity work = (WorkEntity) super.getEntity();
        return work;
    }

    public MaintenanceRealTarget getRealTarget() {
        MaintenanceRealTarget target = factory.createMaintenanceTargetEntity(
                this.getMaintenanceMetaClass().getRealClass(), getEntity()
                        .getRealEntity());
        return (MaintenanceRealTarget) target;
    }

    public String toString() {
        return getClass().getSimpleName() + "[" + getEntity().toString() + "]";
    }
}
