package jp.sourceforge.masme.target;

import jp.sourceforge.masme.validation.ValidationResult;

/**
 * Entityのプロパティのうち、実際のメンテナンス対象ではなく<code>ReferenceProperty</code>の逆側のプロパティを表す
 * 整合性検証対象のプロパティ
 * <p>
 * オブジェクトが整合性を保つためには、
 * そのオブジェクトを参照する全てのプロパティが
 * 整合性を保っていなければならない。
 * このオブジェクトはそのそれぞれのプロパティを表している。
 * <p>
 * このプロパティが整合性を保っているかどうかは
 * <code>invokeValidateMethod()</code>が正常に終了したかどうかによる。
 * このメソッド実行中に例外が発生した場合には、
 * 整合性を保っていないということになる。
 */
public interface ValidateProperty {

    // List<ReferenceProperty> getReferenceProperties();
    /**
     * このプロパティが整合性を保っているかどうかを確認するための
     * メソッドを実行する。
     */
    ValidationResult invokeWorkValidateMethod(MaintenanceWorkTarget entity);

    /**
     * このプロパティが整合性を保っているかどうかを確認するための
     * メソッドを実行する。
     */
    ValidationResult invokeRealValidateMethod(MaintenanceWorkTarget entity);

    boolean isNonDeletedProperty();

}