package jp.sourceforge.masme.service.impl;

import java.util.Date;
import java.util.List;

import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.ReflectTargetService;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectTargetServiceImpl implements ReflectTargetService {

    /** ログ出力オブジェクト */
    Log log = LogFactory.getLog(ReflectTargetServiceImpl.class);

    /**
     * @see jp.sourceforge.masme.service.ReflectTargetService#reflect(java.lang.Class, java.util.Date)
     */
    public void reflect(Class targetClass, Date reflectDate) {
        List<WorkEntity> entities = maintenanceTargetDao.loadWaitReflectAll(
                targetClass, reflectDate);
        for (WorkEntity reflectTarget : entities) {
            MaintenanceWorkTarget maintenanceTargetEntity = maintenanceTargetFactory
                    .createMaintenanceTargetEntity(targetClass, reflectTarget);
            maintenanceTargetEntity.reflect();
        }

    }

    /** MaintenanceTarget DAO */
    private MaintenanceTargetDao maintenanceTargetDao;

    public void setMaintenanceTargetDao(
            MaintenanceTargetDao maintenanceTargetDao) {
        this.maintenanceTargetDao = maintenanceTargetDao;
    }

    private MaintenanceTargetFactory maintenanceTargetFactory;

    public void setMaintenanceTargetFactory(
            MaintenanceTargetFactory maintenanceTargetFactory) {
        this.maintenanceTargetFactory = maintenanceTargetFactory;
    }

}
