package jp.sourceforge.masme.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.LoadTargetService;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadTargetServiceImpl implements LoadTargetService {

    /** ログ出力オブジェクト */
    Log log = LogFactory.getLog(LoadTargetServiceImpl.class);

    /**
     * @see jp.sourceforge.masme.service.LoadTargetService#loadAll(java.lang.Class)
     */
    public List<MaintenanceWorkTarget> loadAll(Class<WorkEntity> targetClass) {
        List<WorkEntity> entities = maintenanceTargetDao.loadAll(targetClass);
        if (log.isDebugEnabled()) {
            log.debug(entities);
        }
        List<MaintenanceWorkTarget> maintenanceTargetEntities = maintenanceTargetFactory
                .createMaintenanceTargetEntity(targetClass, entities);
        return maintenanceTargetEntities;
    }

    /**
     * @see jp.sourceforge.masme.service.LoadTargetService#loadEditAll(java.lang.Class)
     */
    public List<MaintenanceWorkTarget> loadEditAll(Class<WorkEntity> targetClass) {
        List entities = maintenanceTargetDao.loadEditAll(targetClass);
        if (log.isDebugEnabled()) {
            log.debug(entities);
        }
        List<MaintenanceWorkTarget> maintenanceTargetEntities = maintenanceTargetFactory
                .createMaintenanceTargetEntity(targetClass, entities);
        return maintenanceTargetEntities;
    }

    /**
     * @see jp.sourceforge.masme.service.LoadTargetService#loadWaitReflectAll(java.lang.Class, java.util.Date)
     */
    public List<MaintenanceWorkTarget> loadWaitReflectAll(
            Class<WorkEntity> targetClass, Date reflectDate) {

        List entities = maintenanceTargetDao.loadWaitReflectAll(targetClass,
                reflectDate);
        if (log.isDebugEnabled()) {
            log.debug(entities);
        }
        List<MaintenanceWorkTarget> maintenanceTargetEntities = maintenanceTargetFactory
                .createMaintenanceTargetEntity(targetClass, entities);

        return maintenanceTargetEntities;
    }

    /**
     * @see jp.sourceforge.masme.service.LoadTargetService#get(java.lang.Class, java.io.Serializable)
     */
    public MaintenanceWorkTarget get(Class<WorkEntity> targetClass,
            Serializable id) {
        WorkEntity entity = (WorkEntity) maintenanceTargetDao.get(targetClass,
                id);
        MaintenanceTarget target = maintenanceTargetFactory
                .createMaintenanceTargetEntity(targetClass, entity);

        return (MaintenanceWorkTarget) target;
    }

    /** MaintenanceTarget DAO */
    private MaintenanceTargetDao maintenanceTargetDao;

    public void setMaintenanceTargetDao(
            MaintenanceTargetDao maintenanceTargetDao) {
        this.maintenanceTargetDao = maintenanceTargetDao;
    }

    /** MaintenanceTarget Factory */
    private MaintenanceTargetFactory maintenanceTargetFactory;

    public void setMaintenanceTargetFactory(
            MaintenanceTargetFactory maintenanceTargetFactory) {
        this.maintenanceTargetFactory = maintenanceTargetFactory;
    }

}
