package jp.sourceforge.masme.service.impl;

import java.util.Date;

import jp.sourceforge.masme.service.ConfirmTargetService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfirmTargetServiceImpl implements ConfirmTargetService {

    /** ログ出力オブジェクト */
    Log log = LogFactory.getLog(ConfirmTargetServiceImpl.class);

    /**
     * @see jp.sourceforge.masme.service.ConfirmService#cancelConfirm(jp.sourceforge.masme.target.MaintenanceWorkTarget)
     */
    public void cancelConfirm(MaintenanceWorkTarget target) {
        log.debug("cancelConfirm[" + target + "]");
        target.cancelConfirm();
    }

    /**
     * @see jp.sourceforge.masme.service.ConfirmService#changeReflectDate(jp.sourceforge.masme.target.MaintenanceWorkTarget, java.util.Date)
     */
    public void changeReflectDate(MaintenanceWorkTarget target, Date reflectDate) {

        log.debug("changeReflectDate[" + target + "] date:" + reflectDate);

        target.changeScheduleDate(reflectDate);

    }

    /**
     * @see jp.sourceforge.masme.service.ConfirmService#confirm(jp.sourceforge.masme.target.MaintenanceWorkTarget)
     */
    public void confirm(MaintenanceWorkTarget target) {
        log.debug("confirm[" + target + "]");
        target.confirm();
    }

}
