package jp.sourceforge.masme.service;

import java.io.Serializable;
import java.util.List;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

/**
 * メンテナンス対象オブジェクトに対する修正を行うサービスクラス。
 * <p>
 * 登録/更新/削除や修正キャンセルなどのサービスを提供する。
 */
public interface EditTargetService {
    /**
     * 引数で受け取ったメンテナンス対象クラスに大して
     *  {@code MaintenanceTarget}のデフォルト値の入ったオブジェクトを
     * 作成します。
     * 
     * @param targetClass　メンテナンス対象クラス
     * @return　デフォルト値の入った{@code MaintenanceTarget}オブジェクト
     */
    MaintenanceWorkTarget createMaintenanceTarget(Class<? extends WorkEntity> targetClass);

    void add(MaintenanceWorkTarget target, Serializable id,
            List<String> propertyNames, List<Object> propertyValues);

    void edit(MaintenanceWorkTarget target, List<String> propertyNames,
            List<Object> propertyValuesStr);

    MaintenanceWorkTarget cancelEdit(MaintenanceWorkTarget target);

    MaintenanceWorkTarget delete(MaintenanceWorkTarget target);
}
