package jp.sourceforge.masme.meta;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masme.validation.ValidateFunction;

import org.apache.commons.collections.ListUtils;

/**
 * メンテナンス対象のメタ情報を保持したクラス
 * 
 */
public class MetaClass {

    /**
     * メンテナンス対象のワーククラス
     */
    private Class workClass;
    /**
     * メンテナンス対象の本番クラス
     */
    private Class realClass;
    /**
     * メンテナンス対象のID名
     */
    private String idName;
    /**
     * バリデーションメソッド名
     */
    private String validationMethodName;
    
    /**
     * バリデーションメソッド
     */
    private ValidateFunction validationMethod;

    /**
     * メンテナンス対象クラスのメンテナンス対象プロパティ
     */
    private List<MetaProperty> metaProperties;

    private List<ReferenceMetaProperty> referenceMetaProperties;

    protected MetaClass(Class workClass, Class realClass, String idName, String validationMethodName) {
        this.workClass = workClass;
        this.realClass = realClass;
        this.idName = idName;
        this.metaProperties = new ArrayList<MetaProperty>();
        this.referenceMetaProperties = new ArrayList<ReferenceMetaProperty>();
        this.validationMethodName = validationMethodName;
    }

    public Class getWorkClass() {
        return workClass;
    }

    public Class getRealClass() {
        return realClass;
    }

    public String getIdName() {
        return idName;
    }

    @SuppressWarnings("unchecked")
    public List<MetaProperty> getMetaProperties() {
        return ListUtils.unmodifiableList(metaProperties);
    }

    @SuppressWarnings("unchecked")
    public List<ReferenceMetaProperty> getReferenceMetaProperties() {
        return ListUtils.unmodifiableList(referenceMetaProperties);
    }

    void addMetaProperty(MetaProperty metaProperty) {
        if (metaProperties.contains(metaProperty)) {
            throw new IllegalArgumentException("2重登録" + metaProperty + "("
                    + metaProperties + ")");
        }
        metaProperties.add(metaProperty);
    }

    void addReferenceMetaProperty(ReferenceMetaProperty metaProperty) {
        if (referenceMetaProperties.contains(metaProperty)) {
            throw new IllegalArgumentException("2重登録" + metaProperty);
        }
        referenceMetaProperties.add(metaProperty);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((realClass == null) ? 0 : realClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final MetaClass other = (MetaClass) obj;
        if (realClass == null) {
            if (other.realClass != null)
                return false;
        } else if (!realClass.equals(other.realClass))
            return false;
        return true;
    }

    public String getValidationMethodName() {
        return validationMethodName;
    }

    public ValidateFunction getValidationMethod() {
        return validationMethod;
    }

    public void setValidationMethod(ValidateFunction validationMethod) {
        this.validationMethod = validationMethod;
    }


}
