package jp.sourceforge.masme.entity.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Properties;

import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EnumUserType<E extends Enum<E>> implements UserType,
        ParameterizedType {
    Class<E> targetClass;
    ChangeValue changeValue;

    @SuppressWarnings("unchecked")
    public void setParameterValues(Properties parameters) {
        String className = parameters.getProperty("className");
        try {
            targetClass = (Class<E>) Class.forName(className);
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("classNameが見つかりません" + className);
        }
        if (targetClass.isAssignableFrom(EnumValue.class)) {
            changeValue = new EnumValueChangeValue();
        } else {
            changeValue = new SimpleEnumChangeValue();
        }

    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner)
            throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        return changeValue.toObject(value);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index)
            throws HibernateException, SQLException {
        st.setString(index, changeValue.toString((Enum)value));
    }

    public Class returnedClass() {
        return targetClass;
    }

    public int[] sqlTypes() {
        return new int[] { Types.CHAR };
    }

    public Object assemble(Serializable arg0, Object arg1)
            throws HibernateException {
        return arg0;
    }

    public Object deepCopy(Object arg0) throws HibernateException {
        return arg0;
    }

    public Serializable disassemble(Object arg0) throws HibernateException {
        return (Serializable) arg0;
    }

    public boolean equals(Object arg0, Object arg1) throws HibernateException {
        if (arg0 == null && arg1 == null) {
            return true;
        }
        if (arg0 == null || arg1 == null) {
            return false;
        }
        return arg0.equals(arg1);
    }

    public int hashCode(Object arg0) throws HibernateException {
        return arg0.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object arg0, Object arg1, Object arg2)
            throws HibernateException {
        return arg0;
    }
    interface ChangeValue{
        Object toObject(String value);
        String toString(Enum obj);
    }
    /**
     * EnumValueを実装したEnum用のChangeValue
     *
     */
    class EnumValueChangeValue implements ChangeValue {
        public Object toObject(String value) {
            EnumValue enumValue = EnumUtils.getByValue(targetClass, value);
            return enumValue;
        }
        public String toString(Enum obj) {
            EnumValue enumValue = (EnumValue) obj;
            return enumValue.getValue();
        }
        
    }
    /**
     * EnumValueを実装していないEnum用のChangeValue
     *
     */
    class SimpleEnumChangeValue implements ChangeValue {
        public Object toObject(String value) {
            Iterator<E> it =EnumSet.allOf(targetClass).iterator();
            while(it.hasNext()) {
                E en = it.next();
                if(en.name().equals(value)) {
                   return en; 
                }
            }
            return null;
        }
        public String toString(Enum obj) {
            return obj.name();
        }
        
    }

}
