package jp.sourceforge.masme.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * メンテナンス対象プロパティのうち、他のメンテナンス対象エンティティへの参照となるプロパティに対してのアノテーション
 * <p>
 * <code>MaintenanceTargetProperty</code>に対して設定する
 *
 */
@Target(ElementType.ANNOTATION_TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ReferenceTargetProperty {
    /**
     * このプロパティの、同クラス内のワークに対する参照名
     * @return プロパティ名
     */
    String workPropertyName();

    /**
     * このプロパティの逆側のプロパティの参照名
     * @return プロパティ名
     */
    String referencePropertyName();

    /**
     * このプロパティの逆側のプロパティのワークに対する参照名
     * @return プロパティ名
     */
    String workReferencePropertyName();

    /**
     * このプロパティに対するバリデーションメソッドの名前
     * @return メソッド名
     */
    String validationMethodName();
}
