#include "head.h"

extern struct tcontrol *timer_control;
struct timer *make_timer(void)
{
  int timer_number;
  for(timer_number=0;timer_number<MAXTIMER;timer_number++){
    if(timer_control->timer[timer_number].flag==TIMER_NOT_USING){
      timer_control->timer[timer_number].flag=TIMER_FLAG_ALLOC;
      timer_control->timer[timer_number].apli=0;
      return &timer_control->timer[timer_number];
    }
  }
  return 0;
}
void setfifo(struct timer *timer_number,struct fifo *fifo)
{
  timer_number->fifo=fifo;
  return;
}
void free_timer(struct timer *timer_number)
{
  timer_number->flag=TIMER_NOT_USING;
  return;
}
void timer_settime(struct timer *timer_number,unsigned int timeout)
{
  int e;
  struct timer *t,*s;

  timer_number->timeout=timeout+timer_control->count;
  timer_number->flag=TIMER_FLAG_USING;
  e=io_load_eflags();
  io_cli();
  t=timer_control->t0;
  if(timer_number->timeout<=t->timeout){
    timer_control->t0=timer_number;
    timer_number->next=t;
    timer_control->next=timer_number->timeout;
    io_store_eflags(e);
    return;
  }
  for(;;){
    s=t;
    t=t->next;
    if(timer_number->timeout<=t->timeout){
      s->next=timer_number;
      timer_number->next=t;
      io_store_eflags(e);
      return;
    }
  }
}
int timer_cancel(struct timer *timer)
{
  int e;
  struct timer *t;
  e=io_load_eflags();
  io_cli();
  if(timer->flag==TIMER_FLAG_USING){
    if(timer==timer_control->t0){
      t=timer->next;
      timer_control->t0=t;
      timer_control->next=t->timeout;
    }else{
      t=timer_control->t0;
      for(;;){
	if(t->next==timer){
	  break;
	}
	t=t->next;
      }
      t->next=timer->next;
    }
    timer->flag=TIMER_FLAG_ALLOC;
    io_store_eflags(e);
    return 1;
  }
  io_store_eflags(e);
  return 0;
}
void timer_cancelall(struct fifo *fifo)
{
  int e,i;
  struct timer *t;
  e=io_load_eflags();
  io_cli();
  for(i=0;i<MAXTIMER;i++){
    t=&timer_control->timer[i];
    if(t->flag!=0 && t->apli!=0 && t->fifo==fifo){
      timer_cancel(t);
      t->flag=TIMER_NOT_USING;
    }
  }
  io_store_eflags(e);
  return;
}
void setdata_timer(struct timer *timer,int data)
{
  timer->data=data;
  return;
}
