#include "head.h"

extern struct TASKCTL *task_control;
extern struct tcontrol *timer_control;
void taskswitch(void)
{
  struct TASKLEVEL *t=&task_control->level[task_control->now_level];
  struct TASK *new_task,*now_task=t->task_pointer[t->now];
  t->now++;
  if(t->now==t->running){
    t->now=0;
  }
  if(task_control->level_change!=0){
    task_switch_whitch_level();
    t=&task_control->level[task_control->now_level];
  }
  new_task=t->task_pointer[t->now];
  timer_settime(timer_control->multitask_timer,new_task->priority);
  if(new_task!=now_task){
    farjmp(0,new_task->sel);
  }
  return;
}
struct TASK *task_init(void)
{
  int i;
  struct TASK *task,*idle;
  struct segment_descriptor *gdt = (struct segment_descriptor *)adr_gdt;
  task_control=(struct TASKCTL *)alloc4((struct manager *)(MANAGER_ADDR),sizeof (struct TASKCTL));
  for(i=0;i<MAX_TASK;i++){
    task_control->task[i].flag=TASK_NOT_USING;
    task_control->task[i].sel=(TASK_GDT+i)*8;
    task_control->task[i].tss.ldtr=(TASK_GDT+MAX_TASK+i)*8;
    set_segmdesc(gdt+TASK_GDT+i,103,(int) &task_control->task[i].tss,ar_tss32);
    set_segmdesc(gdt+TASK_GDT+MAX_TASK+i,15,(int)task_control->task[i].ldt,ar_ldt);
  }
  for(i=0;i<MAX_TASKLEVELS;i++){
    task_control->level[i].running=0;
    task_control->level[i].now=0;
  }
  task=task_alloc();
  task->flag=TASK_USING;
  task->priority=DEFAULT_PRIORITY;
  task->level=0;
  task_add(task);
  task_switch_whitch_level();
  load_tr(task->sel);
  timer_control->multitask_timer=make_timer();
  timer_settime(timer_control->multitask_timer,task->priority);
  idle=task_alloc();
  idle->tss.esp=alloc4((struct manager *)(MANAGER_ADDR),64*1024)+64*1024;
  idle->tss.eip=(int)&task_idle;
  idle->tss.es=1*8;
  idle->tss.cs=2*8;
  idle->tss.ss=1*8;
  idle->tss.ds=1*8;
  idle->tss.fs=1*8;
  idle->tss.gs=1*8;
  task_run(idle,MAX_TASKLEVELS-1,1);
  task_control->task_fpu=0;
  return task;
}

struct TASK *task_alloc(void)
{
  int i,j;
  struct TASK *task;
  for(i=0;i<MAX_TASK;i++){
    if(task_control->task[i].flag==TASK_NOT_USING){
      task=&task_control->task[i];
      task->flag=TASK_ALLOC;
      task->priority=DEFAULT_PRIORITY;
      task->tss.eflags=0x00000202;
      task->tss.eax=0;
      task->tss.ecx=0;
      task->tss.edx=0;
      task->tss.ebx=0;
      task->tss.ebp=0;
      task->tss.esi=0;
      task->tss.edi=0;
      task->tss.es=0;
      task->tss.ds=0;
      task->tss.fs=0;
      task->tss.gs=0;
      task->tss.iomap=0x40000000;
      task->tss.ss0=0;
      task->fpu[0]=0x037f;
      task->fpu[1]=0x0000;
      task->fpu[2]=0xffff;
      for(j=3;j<108/4;j++){
	task->fpu[i]=0;
      }
      return task;
    }
  }
  return 0;
}

void task_run(struct TASK *task,int level,int priority)
{
  if(level<0){
    level=task->level;
  }
  if(priority>0){
    task->priority=priority;
  }
  if(task->flag==TASK_USING && task->level!=level){
    task_remove(task);
  }
  if(task->flag!=TASK_USING){
    task->level=level;
    task_add(task);
  }
  task_control->level_change=1;
  return;
}
void task_sleep(struct TASK *task)
{
  struct TASK *now_task;
  if(task->flag==TASK_USING){
    now_task=task_now();
    task_remove(task);
    if(task==now_task){
      task_switch_whitch_level();
      now_task=task_now();
      farjmp(0,now_task->sel);
    }
  }
  return;
}
struct TASK *task_now(void)
{
  struct TASKLEVEL *t=&task_control->level[task_control->now_level];
  return t->task_pointer[t->now];
}
void task_add(struct TASK *task)
{
  /* {͂ЂƂ̃xɂPOOȏ̃^XNo^ĂȂׂȂƂȂ */
  struct TASKLEVEL *t=&task_control->level[task->level];
  t->task_pointer[t->running]=task;
  t->running++;
  task->flag=TASK_USING;
  return;
}
void task_remove(struct TASK *task)
{
  int i;
  struct TASKLEVEL *t=&task_control->level[task->level];
  for(i=0;i<t->running;i++){
    if(t->task_pointer[i]==task){
      break;
    }
  }
  t->running--;
  if(i<t->now){
    t->now--;
  }
  if(t->now>=t->running){
    t->now=0;
  }
  task->flag=TASK_ALLOC;
  for(;i<t->running;i++){
    t->task_pointer[i]=t->task_pointer[i+1];
  }
  
  return;
}
void task_switch_whitch_level(void)
{
  int i;
  for(i=0;i<MAX_TASKLEVELS;i++){
    if(task_control->level[i].running>0){
      break;
    }
  }
  task_control->now_level=i;
  task_control->level_change=0;
  return;
}
void task_idle(void)
{
  for(;;){
    io_hlt();
  }
}
   
