#include "head.h"

extern struct manager *memory;
unsigned int memtest(unsigned int start,unsigned int end)
{
  char flg486=0;
  unsigned int eflg,cr0,i;
  eflg=io_load_eflags();
  eflg|=eflags_ac_bit;
  io_store_eflags(eflg);
  eflg=io_load_eflags();
  if ((eflg&eflags_ac_bit)!=0){
    flg486=1;
  }
  eflg&=~eflags_ac_bit;
  io_store_eflags(eflg);
  if (flg486!=0){
    cr0=load_cr0();
    cr0|=cr0_cache_disable;
    store_cr0(cr0);
  }
  i=memtest_main(start,end);
  if (flg486!=0){
    cr0=load_cr0();
    cr0&=~cr0_cache_disable;
    store_cr0(cr0);
  }
  return i;
}
void manager_init(struct manager *memory)
{
  memory->free=0;
  memory->maxfree=0;
  memory->lostsize=0;
  memory->lost=0;
  return;
}
unsigned int memory_total(struct manager *memory)
{
  unsigned int i,total=0;
  for(i=0;i<memory->free;i++){
    total+=memory->frees[i].size;
  }
  return total;
}
unsigned int alloc(struct manager *memory,unsigned int require)
{
  unsigned int i,a;
  for (i=0;i<memory->free;i++){
    if(memory->frees[i].size>=require){
      a=memory->frees[i].addr;
      memory->frees[i].addr+=require;
      memory->frees[i].size-=require;
      if(memory->frees[i].size==0){
	memory->free--;
	for(;i<memory->free;i++){
	  memory->frees[i]=memory->frees[i+1];
	}
      }
      return a;
    }
  }
  return 0;
}
int free(struct manager *memory,unsigned int addr,unsigned int require)
{
  int i,j;
  for(i=0;i<memory->free;i++){
    if(memory->frees[i].addr>addr){
      break;
    }
  }
  if(i>0){
    if(memory->frees[i-1].addr+memory->frees[i-1].size==addr){
      memory->frees[i-1].size+=require;
      if(i<memory->free){
	if(addr+require==memory->frees[i].addr){
	  memory->frees[i-1].size+=memory->frees[i].size;
	  memory->free--;
	  for(;i<memory->free;i++){
	    memory->frees[i]=memory->frees[i+1];
	  }
	}
      }
      return 0;
    }
  }
  if(i<memory->free){
    if(addr+require==memory->frees[i].addr){
      memory->frees[i].addr=addr;
      memory->frees[i].size+=require;
      return 0;
    }
  }
  if(memory->free<manager_free){
    for(j=memory->free;j>i;j--){
      memory->frees[j]=memory->frees[j-1];
    }
    memory->free++;
    if(memory->maxfree<memory->free){
      memory->maxfree=memory->free;
    }
    memory->frees[i].addr=addr;
    memory->frees[i].size=require;
    return 0;
  }
  memory->lost++;
  memory->lostsize+=require;
  return -1;
}
unsigned int alloc4(struct manager *memory,unsigned int require)
{
  unsigned int data;
  require=(require+0xfff)&0xfffff000;
  data=alloc(memory,require);
  return data;
}
int free4(struct manager *memory,unsigned int addr,unsigned int require)
{
  int i;
  require=(require+0xfff)&0xfffff000;
  i=free(memory,addr,require);
  return i;
}
volatile unsigned int memtest_main(unsigned int start, unsigned int end)
{
  unsigned int i, *p, old, pat0 = 0xaa55aa55, pat1 = 0x55aa55aa;
  for (i = start; i <= end; i += 0x1000) {
    p = (unsigned int *) (i + 0xffc);
    old = *p;			/* O̒loĂ */
    *p = pat0;			/* ߂ɏĂ݂ */
    *p ^= 0xffffffff;	/* Ă𔽓]Ă݂ */
    if (*p != pat1) {	/* ]ʂɂȂH */
    not_memory:
      *p = old;
      break;
    }
    *p ^= 0xffffffff;	/* x]Ă݂ */
    if (*p != pat0) {	/* ɖ߂H */
      goto not_memory;
    }
    *p = old;			/* lɖ߂ */
  }
  return i;
}
