#ifndef _HEAD_H_INCLUDED_
#define _HEAD_H_INCLUDED_
/* definenums */

struct biosinfo{
  char cyls,leds,vmode,reserve;
  short fullx,fully;
  char *vram;
};
extern char alpha[4096];
/* main.c */
#define KEYCMD_LED			0xed
#define BIOS_INFO_ADDR			0x0ff0
#define KEYBOARD_BUFFER_LENGTH		64
#define MOUSE_BUFFER_LENGTH		64
#define cons_buffer_length		32
#define close_buffer_length		16
#define OREconsole_buffer_length	64
#define MOUSE_CURSOR_XSIZE		10
#define MOUSE_CURSOR_YSIZE		10
#define font_xsize			8
#define font_ysize			16
#define TASKBAR_WIDTH 16
#define TASKBAR_COLOR 0xd65
#define TASKBAR_CONTENTS_SIZE		96
#define TASKBAR_CONTENTS_COLOR		0xecba
#define TASKBAR_CONTENTS_STR_COLOR	0x0000
#define TASKBAR_SIDELINE_COLOR		0xef25
#define TASKBAR_SIDELINE_SIZE		8
#define DEFAULT_WINDOW_START_POS	0,16
void mouse_task(void);
void keyboard_task(void);
void close_task(void);
void wait_kbc_sendready(void);
void palatte_init(void);
void gdt_idt_init(void);
void window_control_init(void);
void init_pic(void);
void enable_keyboard(void);
void enable_mouse(void);
void enable_pit(void);
void timer_control_init(void);

/* asmfunc.nas */
void io_hlt(void);
void io_cli(void);
void io_out_eight(int port,int data);
int  io_load_eflags(void);
void io_store_eflags(int eflags);
void load_gdtr(int limit,int addr);
void load_idtr(int limit,int addr);
void asm_keyboard_handler(void);
void asm_mouse_handler(void);
void asm_timer_handler(void);
void asm_athlon(void);
void asm_general_exception_handler(void);
void asm_stack_exception(void);
void io_sti(void);
void io_stihlt(void);
int io_in_eight(int port);
int load_cr0(void);
void store_cr0(int cr0);
void store_cr3(int cr3);
void inpg(unsigned long virtual_address);
void paging_on(void);
void asm_pagingfalut_handler(void);
/* graphic.c */
/* iroiro */
#define kuro		0
#define lightaka	1
#define lightmidori	2
#define lightki 	3
#define lightao		4
#define lightmurasaki	5
#define lightmizu 	6
#define siro		7
#define lighthai	8
#define darkaka 	9
#define darkmidori	10
#define darkki		11
#define darkao		12
#define darkmurasaki	13
#define darkmizu	14
#define darkhai		15
/* raw iroiro */
#define GhostWhite 	  	0xf7bf
#define MintCream 	  	0xf7fe
#define FloralWhite 	  	0xffdd
#define AliceBlue 	  	0xefbf
#define LavenderBlush 	  	0xff7e
#define Seashell 	  	0xffbd
#define WhiteSmoke 	  	0xf7be
#define Honeydew 	  	0xeffd
#define LightYellow 	  	0xfffb
#define LightCyan 	  	0xdfff
#define OldLace 	  	0xffbc
#define Cornsilk 	  	0xffbb
#define LemonChiffon 	  	0xffd9
#define LightGoldenrodYellow 	0xf7d9
#define Lavender 	  	0xe73e
#define MistyRose 	  	0xff1b
#define PapayaWhip 	  	0xff7a
#define AntiqueWhite 	  	0xf75a
#define BlanchedAlmond 	  	0xff59
#define Moccasin 	  	0xff16
#define Gainsboro 	  	0xdedb
#define PeachPuff 	  	0xfed6
#define PaleTurquoise 	  	0xaf7d
#define NavajoWhite 	  	0xfef5
#define PaleGoldenrod 	  	0xef34
#define LightGrey 	  	0xd69a
#define LightPink 	  	0xfdb7
#define PowderBlue 	  	0xaefc
#define Thistle 	  	0xd5fa
#define LightBlue 	  	0xaebc
#define LightSteelBlue 	  	0xae1b
#define Aquamarine 	  	0x7ffa
#define LightSkyBlue 	  	0x867e
#define SkyBlue 	  	0x867d
#define PaleGreen 	  	0x97d2
#define Burlywood 	  	0xddb0
#define HotPink 	  	0xfb56
#define LightSalmon 	  	0xfcee
#define LightGreen 	  	0x8f71
#define Fuchsia 	  	0xf81f
#define Magenta 	  	0xf81f
#define DarkGray 	  	0xa554
#define DarkSalmon 	  	0xe4ae
#define SandyBrown 	  	0xf50b
#define LightCoral 	  	0xebef
#define Turquoise 	  	0x3ef9
#define CornflowerBlue 	  	0x64bd
#define MediumTurquoise 	0x4699
#define MediumOrchid 	  	0xb2ba
#define DarkKhaki 	  	0xbdad
#define PaleVioletRed 	  	0xdb72
#define MediumPurple 	  	0x937b
#define MediumAquamarine 	0x6674
#define GreenYellow 	  	0xafe5
#define RosyBrown 	  	0xbc71
#define DarkSeaGreen 	  	0x8dd1
#define MediumSlateBlue 	0x7b3d
#define DeepSkyBlue 	  	0x05ff
#define DodgerBlue 	  	0x1c7f
#define DeepPink 	  	0xf892
#define Goldenrod 	  	0xd523
#define DarkTurquoise 	  	0x0679
#define CadetBlue 	  	0x5cf3
#define YellowGreen 	  	0x9665
#define LightSlateGray 	  	0x7432
#define DarkOrchid 	  	0x9199
#define BlueViolet 	  	0x815b
#define MediumSpringGreen 	0x07d2
#define SlateBlue 	  	0x62d9
#define DarkOrange 	  	0xfc40
#define RoyalBlue 	  	0x3b5b
#define IndianRed 	  	0xcacb
#define SlateGray 	  	0x6bf1
#define Chartreuse 	  	0x7fe0
#define SpringGreen 	  	0x07ef
#define SteelBlue 	  	0x4416
#define LightSeaGreen 	  	0x1d94
#define LawnGreen 	  	0x7fc0
#define DarkViolet 	  	0x901a
#define MediumVioletRed 	0xc0b0
#define MediumSeaGreen 	  	0x3d8d
#define Chocolate 	  	0xcb43
#define DarkGoldenrod 	  	0xb421
#define OrangeRed 	  	0xfa20
#define DimGray 	  	0x634c
#define LimeGreen 	  	0x2e65
#define Crimson 	  	0xd887
#define OliveDrab 	  	0x6c64
#define DarkMagenta 	  	0x8811
#define DarkCyan 	  	0x0451
#define DarkSlateBlue 	  	0x41f1
#define SeaGreen 	  	0x2c4a
#define Firebrick 	  	0xa903
#define DarkOliveGreen 	  	0x5345
#define SaddleBrown 	  	0x8a22
#define ForestGreen 	  	0x1c43
#define DarkSlateGray 	  	0x2a69
#define MediumBlue 	  	0x0019
#define MidnightBlue 	  	0x10cd
#define DarkRed 	  	0x8800
#define DarkBlue 	  	0x0011
#define DarkGreen 	  	0x0300

struct window{
  unsigned short *buffer;
  unsigned int x,y,xsize,ysize;
  unsigned char use;
  char height;
  struct TASK *task;
  int inv;
  unsigned char name[32];
};
void print(struct window *handle,char *str,int x,int y,unsigned char color);
void print_rawcolor(struct window *handle,char *str,int x,int y,unsigned int color);
void dprint(char *str,int x,int y,unsigned char color);
void box(struct window *handle,int x_start,int y_start,int x_end,int y_end,unsigned char color);
void dbox(int x_start,int y_start,int x_end,int y_end,unsigned char color);
void box_rawcolor(struct window *handle,int x_start,int y_start,int x_end,int y_end,int color);
void dot(struct window *handle,int x,int y,unsigned char color);
void print_refreshly(struct window *handle,char *str,int x,int y,int length,unsigned char haikei,unsigned char mozi);
void line(struct window *window,int x0,int y0,int x1,int y1,int col);
/* hardware.c */

/* pic */
#define pic0_icw1	0x0020
#define pic0_ocw2	0x0020
#define pic0_imr	0x0021
#define pic0_icw2	0x0021
#define pic0_icw3	0x0021
#define pic0_icw4	0x0021
#define pic1_icw1	0x00a0
#define pic1_ocw2	0x00a0
#define pic1_imr	0x00a1
#define pic1_icw2	0x00a1
#define pic1_icw3	0x00a1
#define pic1_icw4	0x00a1

/* GDT IDT */
#define adr_idt		0x0026f800
#define limit_idt	0x000007ff
#define adr_gdt		0x00270000
#define limit_gdt	0x0000ffff
#define adr_botpak	0x00280000
#define limit_botpak	0x0007ffff
#define ar_data32_rw	0x4092
#define ar_code32_er	0x409a
#define ar_ldt		0x0082
#define ar_tss32	0x0089
#define ar_intgate32	0x008e

/* KB+M */
#define port_keysta		0x0064
#define keysta_send_notready	0x02

/* keyboard */
#define port_keydat		0x0060
#define port_keycmd		0x0064
#define kbc_mode		0x47
#define keycmd_write_mode	0x60

/* mouse */
#define keycmd_sendto_mouse	0xd4
#define mousecmd_enable		0xf4

struct segment_descriptor{
  short limit_low,base_low;
  char base_mid,access_right;
  char limit_high,base_high;
};
struct gate_descriptor{
  short offset_low,selector;
  char dw_count,access_right;
  short offset_high;
};
struct mouse_dec{
  unsigned char buf[3],phase;
  unsigned char left_button,right_button,middle_button;
  int x,y;
};

void init_gdtidt(void);
void set_segmdesc(struct segment_descriptor *sd,unsigned int limit,int base,int ar);
void set_gatedesc(struct gate_descriptor *gd,int offset,int selector,int ar);
int mouse_decode(struct mouse_dec *dec,int harddata);
void send_mousecmd(unsigned char data);
/* fifo.c */
#define flags_overrun 0x0001
struct fifo{
  int *buffer;
  int write_next,read_next,size,free,flags;
  struct TASK *task;
};
void fifo_init(struct fifo *fifo,int size,struct TASK *task);
void fifo_init_console(struct fifo *fifo,int size,int *buffer,struct TASK *task);
int fifo_in(struct fifo *fifo,int data);
int fifo_out(struct fifo *fifo);
int fifo_status(struct fifo *fifo);

/* memory.c */
#define eflags_ac_bit		0x00040000
#define cr0_cache_disable	0x60000000
#define MANAGER_ADDR		0x003c0000
#define manager_free		4090
struct freeinfo{
  unsigned int addr,size;
};
struct manager{
  int free,maxfree,lostsize,lost;
  struct freeinfo frees[manager_free];
};
unsigned int memtest(unsigned int start,unsigned int end);
volatile unsigned int memtest_main(unsigned int start, unsigned int end);
void manager_init(struct manager *memory);
unsigned int memory_total(struct manager *memory);
unsigned int alloc(struct manager *memory,unsigned int requrie);
int free(struct manager *memory,unsigned int addr,unsigned int size);
unsigned int alloc4(struct manager *memory,unsigned int require);
int free4(struct manager *memory,unsigned int addr,unsigned int require);
/* timer.c */
#define pit_ctrl		0x0043
#define pit_cnt0		0x0040
#define TIMER_NOT_USING 0
#define TIMER_FLAG_ALLOC 1
#define TIMER_FLAG_USING 2
#define MAXTIMER 256
struct timer{
  unsigned int timeout;
  struct fifo *fifo;
  int data;
  struct timer *next;
  unsigned char flag,apli;
};
struct tcontrol{
  unsigned int count;
  unsigned int next;
  struct timer timer[MAXTIMER];
  struct timer *t0;
  struct timer *multitask_timer;
};
struct timer *make_timer(void);
void free_timer(struct timer *timer_number);
void timer_settime(struct timer *timer_number,unsigned int timeout);
void setdata_timer(struct timer *timer,int data);
void setfifo(struct timer *timer_number,struct fifo *fifo);
int timer_cancel(struct timer *timer);
void timer_cancelall(struct fifo *fifo);
/* window.c */
#define window_titlesize	16
#define maxwindow		100
#define window_using		1
#define window_not_using	0
#define VISIBLE		-1
struct wcontrol{
  unsigned char *map;
  int top;
  struct window window[maxwindow];
  struct window *window_pointer[maxwindow];
  struct window *key_win;
  struct window *back_window,*mouse_window,*taskbar_window;
};

struct window *make_window(unsigned int x,unsigned int y,unsigned int xsize,unsigned int ysize,unsigned char *name);
struct window *make_external_window(unsigned int x,unsigned int y,unsigned int xsize,unsigned int ysize,int invisible);
struct window *make_window_nobuf(unsigned int x,unsigned int y,unsigned int xsize,unsigned int ysize);
void window_setbuf(struct window *window,unsigned short *buffer);
void move_window(struct window *handle,unsigned int x,unsigned int y);
void close_window(struct window *handle);
void refresh_window(struct window *window,int redrow_startx,int redrow_starty,int redrow_endx,int redrow_endy);
void refresh_map(int vx0, int vy0, int vx1, int vy1, int h0);
void refresh_window_main(int vx0, int vy0, int vx1, int vy1, int h0, int h1);
void switch_window(struct window *sht, int height);
void switch_window_top(struct window *sht);
void write_title(struct window *handle,int state);
/* mtask.c */

#define TASK_GDT		3
#define TASK_NOT_USING		0
#define TASK_ALLOC		1
#define TASK_USING		2
#define DEFAULT_PRIORITY	2
#define MAX_TASK		1000
#define MAX_TASK_LEVEL		100
#define MAX_TASKLEVELS		10

struct tss {
  int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
  int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
  int es, cs, ss, ds, fs, gs;
  int ldtr, iomap;
};
struct TASK{
  int	sel,flag;
  int	level,priority;
  struct tss	tss;
  struct fifo fifo;
  struct segment_descriptor ldt[2];
  int ds_base,stack;
  struct CONSOLE *cons;
  struct FILEHANDLE *fhandle;
  int fpu[108/4];
  unsigned char name[32];
};

struct TASKLEVEL{
  int		 running;
  int		 now;
  struct TASK	*task_pointer[MAX_TASK_LEVEL];
};
struct TASKCTL{
  int now_level;
  char level_change;
  struct TASKLEVEL level[MAX_TASKLEVELS];
  struct TASK task[MAX_TASK];
  struct TASK *task_fpu;
  struct TASK *task_mouse,*task_keyboard,*task_close,*task_fdc;
};
void load_tr(int tr);
void farjmp(int eip,int cs);
void farcall(int eip,int cs);
struct TASK *task_init(void);
struct TASK *task_alloc(void);
void task_run(struct TASK *task,int level,int priority);
void taskswitch(void);
void task_sleep(struct TASK *task);
struct TASK *task_now(void);
void task_add(struct TASK *task);
void task_remove(struct TASK *task);
void task_switch_whitch_level(void);
void task_idle(void);
/* handler.c */
void keyboard_handler(int *esp);
void mouse_handler(int *esp);
void timer_handler(int *esp);
void athlon(int *esp);
int *stack_exception(int *esp);
int *general_exception_handler(int *esp);
int *fpuhandler(int *esp);
void fdc_handler(int *esp);
/* beep.c */
void beepoff(void);
void beepon(int data);
/* clock.c */
struct clock {
  unsigned short year;
  unsigned char month, day, hour, min, sec;
};
void clockGet(struct clock *c);
void clockRtc(unsigned char *t);
/* file.c */
#define FAT_SEARCH	0xffffffff
#define ADR_DISKIMG	0x00100000
#define MAX_FILES	224
struct FILEINFO {
  unsigned char name[8], ext[3], type;
  char reserve[10];
  unsigned short time, date, clustno;
  unsigned int size;
};
struct ROOTDIRECTORY{
  unsigned char name[11];
  unsigned char attr;
  unsigned char reserved[10];
  unsigned short time;
  unsigned short date;
  unsigned short clustno;
  unsigned long size;
};
struct FDC_REQ {
  int mode, cyl, head, num, sector_bgn, sector_end;
};

struct FILEHANDLE{
  char *buf;
  int size;
  int pos;
  int write_cur;
  int flag;
  int tek;
  struct FILEINFO *finfo;
  struct FDC_REQ *freq;
};
struct DATA {
  unsigned day   : 5;   // 
  unsigned month : 4;   // 
  unsigned year  : 7;   // N
};
struct TIME {
  unsigned sec  : 5;   // b(2{ėp)
  unsigned min   : 6;   // 
  unsigned hour  : 5;   // 
};
	
struct FILEINFO *file_create(char *_name, struct FILEINFO *finfo, int max,char type);
void file_delete(struct FILEINFO *finfo);
void file_rebuildfat(int clustno);
int file_reservefat(void);
int file_setfat(int clustno, int num);
struct FILEHANDLE *file_open(struct FILEHANDLE *fh, char *name, char mode);
char *get_imgaddr(struct FILEHANDLE *fh, int cur, int err, int *clustno_);
void file_write(struct FILEHANDLE *fh, char *data, int len, struct FDC_REQ *freq);
void file_clear(struct FILEINFO *finfo);
void file_close(struct FILEHANDLE *fh);
int file_read(struct FILEHANDLE *fh, char *to, int len);

void file_readfat(int *fat,unsigned char *rawfat);
void file_loadfile(int clustno,int size,char *buf,int *fat,char *img);
char *file_loadfile2(int clustno, int *psize);
struct FILEINFO *file_search(char *name,struct FILEINFO *finfo,int max);
void rename_file(struct FILEINFO *finfo,char *name);
/* console.c */
#define console_xsize	500
#define console_ysize	500
#define CONS_FILE_HANDLES 8
struct CONSOLE{
  struct window *window;
  int cur_x,cur_y,cur_c;
  int shift;
  int cmdline_count;
  struct timer *timer;
  char cmdline[64];
  int flag;
  struct FILEHANDLE fhandle[CONS_FILE_HANDLES];
  unsigned char *commandbuffer;
};
void console(void);
void print_cons(struct CONSOLE *cons,char *str,unsigned char color);
void print_cons_char(struct CONSOLE *cons,char chr,unsigned char color);
void cons_newline(struct CONSOLE *cons);
void cmd_mem(struct CONSOLE *cons);
void cmd_cls(struct CONSOLE *cons);
void cons_runcmd(char *cmdline,struct CONSOLE *cons,int *fat);
void cmd_ls(struct CONSOLE *cons);
int cmd_app(struct CONSOLE *cons,int *fat,char *cmdline);
void keywin_on(struct window *key_win);
void keywin_off(struct window *key_win);
void close_consoletask(struct TASK *task);
void close_console(struct window *window);
struct window *open_console(void);
void cmd_exit(struct CONSOLE *cons,int *fat);
void cmd_printtime(struct CONSOLE *cons);
/* apli */
void asm_cons_putchar(void);
void asm_hrb_api(void);
void asm_end_app(void);
int *hrb_api(int edi,int esi,int ebp,int esp,int ebx,int edx,int ecx,int eax);
void cons_printstr0(struct CONSOLE *cons,char *s);
void cons_printstr1(struct CONSOLE *cons,char *s,int l);
void start_app(int eip,int cs,int esp,int ds,int *tss_esp0);
struct MOUSE_INFO {
  int x, y;
};
/* fpu.c */
void clts(void);
void fnsave(int *addr);
void frstor(int *addr);
void asm_fpuhandler(void);
/* fdc.c */
void task_floppy(void);
#define FDC_BUFFER_LENGTH	128
#define ADR_FDC_DMA		0x00400000
#define CMD_MOTER_OFF		0xff
#define MOTER_ON		0
#define MOTER_OFF		1
#define ST0			0
#define ST1			1
#define ST2			2
#define CYL			3
#define HEAD			4
#define SECTOR			5
#define ERROR			0
#define SUCCESS			1

void init_fdc(void);
struct FDC_REQ *start_fdc_req(int mode);
void add_fdc_req(struct FDC_REQ *freq, int secno);
void end_fdc_req(struct FDC_REQ *freq);
void add_fdc_req_addr(struct FDC_REQ *freq, char *addr, int size);
void end_fdc_req(struct FDC_REQ *freq);
void flush_fdc_req(struct FDC_REQ *freq);
void asm_fdc_handler(void);
/* OREconsole.c */
struct window *open_OREconsole(void);
void OREconsole(void);
void close_OREconsole(struct window *window);
/* other os */
struct SYS_INFO {
  unsigned char cyls;     /* u[gZN^͂ǂ܂ŃfBXNǂ񂾂̂ */
  unsigned char leds;     /* u[g̃L[{[hLED̏ */
  unsigned char vmode;     /* rfI[h  rbgJ[ */
  unsigned char reserve;  /* \ */
  unsigned short scrnx; /* ʉ𑜓x */
  unsigned short scrny; /* ʉ𑜓x */
  unsigned char *vram;    /* VRAM̃AhX */
  unsigned short os_type;  /* OS̎ */
};
struct TIME_INFO {
  int year, month, day, hour, minutes, second;
};
/* reset.c */
void reset(void);
/* icon.c */
#define MAX_ICONS	10
#define ICON_NOT_USING	0
#define ICON_USING	1
struct PICTURE {
  int x,y;
  unsigned short *buffer;
};
struct DLL_STRPICENV {	/* 64KB */
  int work[64 * 1024 / 4];
};
struct RGB {
  unsigned char b, g, r, t;
};
struct PICTURE *loadicon(char *fname);
void drawicon(struct PICTURE *pict,struct window *back_window,int px,int py);
unsigned short rgb2pal(int r, int g, int b, int x, int y);
/* bmp.nasm */
int info_BMP(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_BMP(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* jpeg.c */
int info_JPEG(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_JPEG(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);
/* tek.c */
int tek_getsize(unsigned char *p);
int tek_decomp(unsigned char *p, char *q, int size);
/* pad.c */
struct window *open_pad(void);
/* page.c */
typedef unsigned long PAGE_TABLE_ENTRY;
typedef unsigned long PAGE_DIRECTORY_ENTRY;
typedef PAGE_TABLE_ENTRY            PAGE_TABLE;
typedef PAGE_DIRECTORY_ENTRY        PAGE_DIRECTORY;
void pagingfalut_handler(int *esp);
void kmemset(void *str,unsigned char c, int size);
void setPteFlags(PAGE_TABLE_ENTRY *entry,unsigned long flags);
void clearPteFlags(PAGE_TABLE_ENTRY *entry,unsigned long flags);
void setPtePageFrameAddress(PAGE_TABLE_ENTRY *entry,unsigned long page_frame_address);
unsigned long getPtePageFrameAddress(PAGE_TABLE_ENTRY *entry);
int isPtePresent(PAGE_TABLE_ENTRY *entry);
int isPteWritable( PAGE_TABLE_ENTRY* entry );
void setPdeFlags(PAGE_DIRECTORY_ENTRY *entry,unsigned long flags);
void clearPdeFlags(PAGE_DIRECTORY_ENTRY *entry,unsigned long flags);
void setPdePageFrameAddress(PAGE_DIRECTORY_ENTRY *entry,unsigned long page_table_address );
unsigned long getPdePageTableAddress(PAGE_DIRECTORY_ENTRY *entry );
int isPdePresent(PAGE_DIRECTORY_ENTRY *entry );
int isPdeWritable(PAGE_DIRECTORY_ENTRY *entry );
PAGE_TABLE_ENTRY *allocPage(PAGE_TABLE_ENTRY *entry);
void freePage(PAGE_TABLE_ENTRY *entry);
unsigned long getPteIndex(unsigned long virtual_address );
PAGE_TABLE_ENTRY *getPTE(PAGE_TABLE *table,unsigned long virtual_address);
unsigned long getPdeIndex(unsigned long virtual_address);
PAGE_DIRECTORY_ENTRY *getPDE(PAGE_DIRECTORY *directory,unsigned long virtual_address);
void writeCPUCR3(unsigned long value);
void switchNewPDE(PAGE_DIRECTORY *directory);
PAGE_DIRECTORY *getCurrentPageDirectory(void);
void flushTLB(unsigned long virtual_address);
int mapPage(unsigned long physical_address,unsigned long virtual_address);
int initVirtualMemoryManagement(void);
void pagingOn(void);
/* b&m.c */
int kmp_search(const char *text, const char *pattern);
/* lisp.c */
int lisp(char *cmdline);
#endif
