#include "head.h"
extern struct biosinfo *basic;
extern struct wcontrol *window_control;
extern unsigned short table_8_565[256];

void palatte_init(void)
{
  static unsigned char table_rgb[16*3]={
    0x00,0x00,0x00,
    0xff,0x00,0x00,
    0x00,0xff,0x00,
    0xff,0xff,0x00,
    0x00,0x00,0xff,
    0xff,0x00,0xff,
    0x00,0xff,0xff,
    0xff,0xff,0xff,
    0xc6,0xc6,0xc6,
    0x84,0x00,0x00,
    0x00,0x84,0x00,
    0x84,0x84,0x00,
    0x00,0x00,0x84,
    0x84,0x00,0x84,
    0x00,0x84,0x84,
    0x84,0x84,0x84 
  };
  int i, r, g, b;
  for (i = 0; i < 16; i++) {
    r = table_rgb[i * 3 + 0];
    g = table_rgb[i * 3 + 1];
    b = table_rgb[i * 3 + 2];
    table_8_565[i] = (unsigned short) (((r << 8) & 0xf800) |
				       ((g << 3) & 0x07e0) | (b >> 3));
  }
  for (b = 0; b < 6; b++) {
    for (g = 0; g < 6; g++) {
      for (r = 0; r < 6; r++) {
	table_8_565[r + g * 6 + b * 36 + 16] =
	  (unsigned short) ((((r * 51) << 8) & 0xf800) |
			    (((g * 51) << 3) & 0x07e0) | ((b * 51) >> 3));
      }
    }
  }
}
void box(struct window *handle,int x_start,int y_start,int x_end,int y_end,unsigned char color)
{
  int x,y;
  for(y=y_start;y<=y_end;y++){
    for(x=x_start;x<=x_end;x++){
      handle->buffer[y*handle->xsize+x]=table_8_565[color];
    }
  }
  refresh_window(handle,x_start,y_start,x_end,y_end);
  return;
}
void box_rawcolor(struct window *handle,int x_start,int y_start,int x_end,int y_end,int color)
{
  int x,y;
  for(y=y_start;y<=y_end;y++){
    for(x=x_start;x<=x_end;x++){
      handle->buffer[y*handle->xsize+x]=color;
    }
  }
  refresh_window(handle,x_start,y_start,x_end,y_end);
  return;
}
void dbox(int x_start,int y_start,int x_end,int y_end,unsigned char color)
{
  int x,y;
  for(y=y_start;y<=y_end;y++) {
    for(x=x_start;x<=x_end;x++)
      basic->vram[y*basic->fullx+x]=table_8_565[color];
  }
  return;
}
void dot(struct window *handle,int x,int y,unsigned char color)
{
  handle->buffer[y*handle->xsize+x]=table_8_565[color];
  refresh_window(handle,x,y,x+1,y+1);
  return;
}
void print(struct window *handle,char *str,int x,int y,unsigned char color)
{
  /* EBhEɂĕی삳ꂽ\@ */
  int i,j;
  unsigned short *write_position;
  char data,*character;
  extern char alpha[4096];
  for(j=0;*str!=0x00;str++,j++){ /* k܂ő */
    character=alpha+ *str * font_ysize;
    for(i=0;i<font_ysize;i++){
      write_position=handle->buffer;
      write_position+=(unsigned short)((y+i)*handle->xsize+j*font_xsize+x);
      data=character[i];
      if((data&0x80)!=0){write_position[0]=table_8_565[color];}
      if((data&0x40)!=0){write_position[1]=table_8_565[color];}
      if((data&0x20)!=0){write_position[2]=table_8_565[color];}
      if((data&0x10)!=0){write_position[3]=table_8_565[color];}
      if((data&0x08)!=0){write_position[4]=table_8_565[color];}
      if((data&0x04)!=0){write_position[5]=table_8_565[color];}
      if((data&0x02)!=0){write_position[6]=table_8_565[color];}
      if((data&0x01)!=0){write_position[7]=table_8_565[color];}
    }
  }
  refresh_window(handle,x,y,x+j*font_xsize,y+j*font_ysize);
  /* ł816̓tHg̃TCYɈˑĂ */
  /* ϐj+͕\ɂȂ̂łȂ */
  return;
}

void print_rawcolor(struct window *handle,char *str,int x,int y,unsigned int color)
{
  /* EBhEɂĕی삳ꂽ\@ */
  int i,j;
  unsigned short *write_position;
  char data,*character;
  extern char alpha[4096];
  for(j=0;*str!=0x00;str++,j++){ /* k܂ő */
    character=alpha+ *str * font_ysize;
    for(i=0;i<font_ysize;i++){
      write_position=handle->buffer+(y+i)*handle->xsize+j*font_xsize+x;
      data=character[i];
      if((data&0x80)!=0){write_position[0]=color;}
      if((data&0x40)!=0){write_position[1]=color;}
      if((data&0x20)!=0){write_position[2]=color;}
      if((data&0x10)!=0){write_position[3]=color;}
      if((data&0x08)!=0){write_position[4]=color;}
      if((data&0x04)!=0){write_position[5]=color;}
      if((data&0x02)!=0){write_position[6]=color;}
      if((data&0x01)!=0){write_position[7]=color;}
    }
  }
  refresh_window(handle,x,y,x+j*font_xsize,y+j*font_ysize);
  /* ł816̓tHg̃TCYɈˑĂ */
  /* ϐj+͕\ɂȂ̂łȂ */
  return;
}

void dprint(char *str,int x,int y,unsigned char color)
{
  int i,j;
  unsigned short *write_position;
  char data,*character;
  extern char alpha[4096];
  for(j=0;*str!=0x00;str++,j++){
    character=alpha+ *str * font_ysize;
    for(i=0;i<font_ysize;i++){
      write_position=basic->vram;
      write_position+=(unsigned short)((y+i)*basic->fullx+j*font_xsize+x);
      data=character[i];
      if((data&0x80)!=0){write_position[0]=table_8_565[color];}
      if((data&0x40)!=0){write_position[1]=table_8_565[color];}
      if((data&0x20)!=0){write_position[2]=table_8_565[color];}
      if((data&0x10)!=0){write_position[3]=table_8_565[color];}
      if((data&0x08)!=0){write_position[4]=table_8_565[color];}
      if((data&0x04)!=0){write_position[5]=table_8_565[color];}
      if((data&0x02)!=0){write_position[6]=table_8_565[color];}
      if((data&0x01)!=0){write_position[7]=table_8_565[color];}
    }
  }
  return;
}
void print_refreshly(struct window *handle,char *str,int x,int y,int length,unsigned char haikei,unsigned char mozi)
{
  box(handle,x,y,x+length*font_xsize,y+font_ysize,haikei);
  print(handle,str,x,y,mozi);
}
void line(struct window *window,int x0,int y0,int x1,int y1,int col)
{
  int i, x, y, len, dx, dy;
  unsigned short *sp;

  dx = x1 - x0;
  dy = y1 - y0;
  x = x0 << 10;
  y = y0 << 10;
  if (dx < 0){
    dx = - dx;
  }
  if (dy < 0){
    dy = - dy;
  }
  if (dx >= dy) {
    len = dx + 1;
    if (x0 > x1) {
      dx = - 1024;
    } else {
      dx = 1024;
    }
    if (y0 <= y1) {
      dy = ((y1 - y0 + 1) << 10) / len;
    } else {
      dy = ((y1 - y0 - 1) << 10) / len;
    }
  } else {
    len = dy + 1;
    if (y0 > y1) {
      dy = - 1024;
    } else {
      dy = 1024;
    }
    if (x0 <= x1) {
      dx = ((x1 - x0 + 1) << 10) / len;
    } else {
      dx = ((x1 - x0 - 1) << 10) / len;
    }
  }

  sp = (unsigned short *) (window->buffer);
  for (i = 0; i < len; i++) {
    sp[(y >> 10) * window->xsize + (x >> 10)] = table_8_565[col];
    x += dx;
    y += dy;
  }
  return;
}
